<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderReceipt StructType
 * @subpackage Structs
 */
class OrderReceipt extends AbstractStructBase
{
    /**
     * The FsReceiptDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FsReceiptDate;
    /**
     * The FsReceiptTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $FsReceiptTotal;
    /**
     * The FsReceiptType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FsReceiptType;
    /**
     * The FsDocNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FsDocNumber;
    /**
     * The FsFiscalSignDoc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FsFiscalSignDoc;
    /**
     * The FsFiscalNumberDoc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FsFiscalNumberDoc;
    /**
     * The FsReceiptFA
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FsReceiptFA;
    /**
     * Constructor method for OrderReceipt
     * @uses OrderReceipt::setFsReceiptDate()
     * @uses OrderReceipt::setFsReceiptTotal()
     * @uses OrderReceipt::setFsReceiptType()
     * @uses OrderReceipt::setFsDocNumber()
     * @uses OrderReceipt::setFsFiscalSignDoc()
     * @uses OrderReceipt::setFsFiscalNumberDoc()
     * @uses OrderReceipt::setFsReceiptFA()
     * @param string $fsReceiptDate
     * @param float $fsReceiptTotal
     * @param int $fsReceiptType
     * @param string $fsDocNumber
     * @param string $fsFiscalSignDoc
     * @param string $fsFiscalNumberDoc
     * @param string $fsReceiptFA
     */
    public function __construct($fsReceiptDate = null, $fsReceiptTotal = null, $fsReceiptType = null, $fsDocNumber = null, $fsFiscalSignDoc = null, $fsFiscalNumberDoc = null, $fsReceiptFA = null)
    {
        $this
            ->setFsReceiptDate($fsReceiptDate)
            ->setFsReceiptTotal($fsReceiptTotal)
            ->setFsReceiptType($fsReceiptType)
            ->setFsDocNumber($fsDocNumber)
            ->setFsFiscalSignDoc($fsFiscalSignDoc)
            ->setFsFiscalNumberDoc($fsFiscalNumberDoc)
            ->setFsReceiptFA($fsReceiptFA);
    }
    /**
     * Get FsReceiptDate value
     * @return string
     */
    public function getFsReceiptDate()
    {
        return $this->FsReceiptDate;
    }
    /**
     * Set FsReceiptDate value
     * @param string $fsReceiptDate
     * @return \StructType\OrderReceipt
     */
    public function setFsReceiptDate($fsReceiptDate = null)
    {
        // validation for constraint: string
        if (!is_null($fsReceiptDate) && !is_string($fsReceiptDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fsReceiptDate, true), gettype($fsReceiptDate)), __LINE__);
        }
        $this->FsReceiptDate = $fsReceiptDate;
        return $this;
    }
    /**
     * Get FsReceiptTotal value
     * @return float
     */
    public function getFsReceiptTotal()
    {
        return $this->FsReceiptTotal;
    }
    /**
     * Set FsReceiptTotal value
     * @param float $fsReceiptTotal
     * @return \StructType\OrderReceipt
     */
    public function setFsReceiptTotal($fsReceiptTotal = null)
    {
        // validation for constraint: float
        if (!is_null($fsReceiptTotal) && !(is_float($fsReceiptTotal) || is_numeric($fsReceiptTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fsReceiptTotal, true), gettype($fsReceiptTotal)), __LINE__);
        }
        $this->FsReceiptTotal = $fsReceiptTotal;
        return $this;
    }
    /**
     * Get FsReceiptType value
     * @return int
     */
    public function getFsReceiptType()
    {
        return $this->FsReceiptType;
    }
    /**
     * Set FsReceiptType value
     * @param int $fsReceiptType
     * @return \StructType\OrderReceipt
     */
    public function setFsReceiptType($fsReceiptType = null)
    {
        // validation for constraint: int
        if (!is_null($fsReceiptType) && !(is_int($fsReceiptType) || ctype_digit($fsReceiptType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fsReceiptType, true), gettype($fsReceiptType)), __LINE__);
        }
        $this->FsReceiptType = $fsReceiptType;
        return $this;
    }
    /**
     * Get FsDocNumber value
     * @return string|null
     */
    public function getFsDocNumber()
    {
        return $this->FsDocNumber;
    }
    /**
     * Set FsDocNumber value
     * @param string $fsDocNumber
     * @return \StructType\OrderReceipt
     */
    public function setFsDocNumber($fsDocNumber = null)
    {
        // validation for constraint: string
        if (!is_null($fsDocNumber) && !is_string($fsDocNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fsDocNumber, true), gettype($fsDocNumber)), __LINE__);
        }
        $this->FsDocNumber = $fsDocNumber;
        return $this;
    }
    /**
     * Get FsFiscalSignDoc value
     * @return string|null
     */
    public function getFsFiscalSignDoc()
    {
        return $this->FsFiscalSignDoc;
    }
    /**
     * Set FsFiscalSignDoc value
     * @param string $fsFiscalSignDoc
     * @return \StructType\OrderReceipt
     */
    public function setFsFiscalSignDoc($fsFiscalSignDoc = null)
    {
        // validation for constraint: string
        if (!is_null($fsFiscalSignDoc) && !is_string($fsFiscalSignDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fsFiscalSignDoc, true), gettype($fsFiscalSignDoc)), __LINE__);
        }
        $this->FsFiscalSignDoc = $fsFiscalSignDoc;
        return $this;
    }
    /**
     * Get FsFiscalNumberDoc value
     * @return string|null
     */
    public function getFsFiscalNumberDoc()
    {
        return $this->FsFiscalNumberDoc;
    }
    /**
     * Set FsFiscalNumberDoc value
     * @param string $fsFiscalNumberDoc
     * @return \StructType\OrderReceipt
     */
    public function setFsFiscalNumberDoc($fsFiscalNumberDoc = null)
    {
        // validation for constraint: string
        if (!is_null($fsFiscalNumberDoc) && !is_string($fsFiscalNumberDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fsFiscalNumberDoc, true), gettype($fsFiscalNumberDoc)), __LINE__);
        }
        $this->FsFiscalNumberDoc = $fsFiscalNumberDoc;
        return $this;
    }
    /**
     * Get FsReceiptFA value
     * @return string|null
     */
    public function getFsReceiptFA()
    {
        return $this->FsReceiptFA;
    }
    /**
     * Set FsReceiptFA value
     * @param string $fsReceiptFA
     * @return \StructType\OrderReceipt
     */
    public function setFsReceiptFA($fsReceiptFA = null)
    {
        // validation for constraint: string
        if (!is_null($fsReceiptFA) && !is_string($fsReceiptFA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fsReceiptFA, true), gettype($fsReceiptFA)), __LINE__);
        }
        $this->FsReceiptFA = $fsReceiptFA;
        return $this;
    }
}
