<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOrderDocument ArrayType
 * @subpackage Arrays
 */
class ArrayOfOrderDocument extends AbstractStructArrayBase
{
    /**
     * The OrderDocument
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OrderDocument[]
     */
    public $OrderDocument;
    /**
     * Constructor method for ArrayOfOrderDocument
     * @uses ArrayOfOrderDocument::setOrderDocument()
     * @param \StructType\OrderDocument[] $orderDocument
     */
    public function __construct(array $orderDocument = array())
    {
        $this
            ->setOrderDocument($orderDocument);
    }
    /**
     * Get OrderDocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OrderDocument[]|null
     */
    public function getOrderDocument()
    {
        return isset($this->OrderDocument) ? $this->OrderDocument : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderDocumentForArrayConstraintsFromSetOrderDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfOrderDocumentOrderDocumentItem) {
            // validation for constraint: itemType
            if (!$arrayOfOrderDocumentOrderDocumentItem instanceof \StructType\OrderDocument) {
                $invalidValues[] = is_object($arrayOfOrderDocumentOrderDocumentItem) ? get_class($arrayOfOrderDocumentOrderDocumentItem) : sprintf('%s(%s)', gettype($arrayOfOrderDocumentOrderDocumentItem), var_export($arrayOfOrderDocumentOrderDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderDocument property can only contain items of type \StructType\OrderDocument, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OrderDocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OrderDocument[] $orderDocument
     * @return \ArrayType\ArrayOfOrderDocument
     */
    public function setOrderDocument(array $orderDocument = array())
    {
        // validation for constraint: array
        if ('' !== ($orderDocumentArrayErrorMessage = self::validateOrderDocumentForArrayConstraintsFromSetOrderDocument($orderDocument))) {
            throw new \InvalidArgumentException($orderDocumentArrayErrorMessage, __LINE__);
        }
        if (is_null($orderDocument) || (is_array($orderDocument) && empty($orderDocument))) {
            unset($this->OrderDocument);
        } else {
            $this->OrderDocument = $orderDocument;
        }
        return $this;
    }
    /**
     * Add item to OrderDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderDocument $item
     * @return \ArrayType\ArrayOfOrderDocument
     */
    public function addToOrderDocument(\StructType\OrderDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderDocument) {
            throw new \InvalidArgumentException(sprintf('The OrderDocument property can only contain items of type \StructType\OrderDocument, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderDocument[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\OrderDocument|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\OrderDocument|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\OrderDocument|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\OrderDocument|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\OrderDocument|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OrderDocument
     */
    public function getAttributeName()
    {
        return 'OrderDocument';
    }
}
