<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateOrderDateDelivery StructType
 * @subpackage Structs
 */
class UpdateOrderDateDelivery extends AbstractStructBase
{
    /**
     * The orderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $orderId;
    /**
     * The dateIntervalDelivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateInterval
     */
    public $dateIntervalDelivery;
    /**
     * The accessKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accessKey;
    /**
     * Constructor method for UpdateOrderDateDelivery
     * @uses UpdateOrderDateDelivery::setOrderId()
     * @uses UpdateOrderDateDelivery::setDateIntervalDelivery()
     * @uses UpdateOrderDateDelivery::setAccessKey()
     * @param int $orderId
     * @param \StructType\DateInterval $dateIntervalDelivery
     * @param string $accessKey
     */
    public function __construct($orderId = null, \StructType\DateInterval $dateIntervalDelivery = null, $accessKey = null)
    {
        $this
            ->setOrderId($orderId)
            ->setDateIntervalDelivery($dateIntervalDelivery)
            ->setAccessKey($accessKey);
    }
    /**
     * Get orderId value
     * @return int
     */
    public function getOrderId()
    {
        return $this->orderId;
    }
    /**
     * Set orderId value
     * @param int $orderId
     * @return \StructType\UpdateOrderDateDelivery
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: int
        if (!is_null($orderId) && !(is_int($orderId) || ctype_digit($orderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->orderId = $orderId;
        return $this;
    }
    /**
     * Get dateIntervalDelivery value
     * @return \StructType\DateInterval|null
     */
    public function getDateIntervalDelivery()
    {
        return $this->dateIntervalDelivery;
    }
    /**
     * Set dateIntervalDelivery value
     * @param \StructType\DateInterval $dateIntervalDelivery
     * @return \StructType\UpdateOrderDateDelivery
     */
    public function setDateIntervalDelivery(\StructType\DateInterval $dateIntervalDelivery = null)
    {
        $this->dateIntervalDelivery = $dateIntervalDelivery;
        return $this;
    }
    /**
     * Get accessKey value
     * @return string|null
     */
    public function getAccessKey()
    {
        return $this->accessKey;
    }
    /**
     * Set accessKey value
     * @param string $accessKey
     * @return \StructType\UpdateOrderDateDelivery
     */
    public function setAccessKey($accessKey = null)
    {
        // validation for constraint: string
        if (!is_null($accessKey) && !is_string($accessKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessKey, true), gettype($accessKey)), __LINE__);
        }
        $this->accessKey = $accessKey;
        return $this;
    }
}
