<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExternalRoute StructType
 * @subpackage Structs
 */
class ExternalRoute extends AbstractStructBase
{
    /**
     * The DeliveryPlaceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeliveryPlaceID;
    /**
     * The RoutingDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RoutingDate;
    /**
     * The RouteId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RouteId;
    /**
     * The Orders
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $Orders;
    /**
     * Constructor method for ExternalRoute
     * @uses ExternalRoute::setDeliveryPlaceID()
     * @uses ExternalRoute::setRoutingDate()
     * @uses ExternalRoute::setRouteId()
     * @uses ExternalRoute::setOrders()
     * @param int $deliveryPlaceID
     * @param string $routingDate
     * @param int $routeId
     * @param \ArrayType\ArrayOfInt $orders
     */
    public function __construct($deliveryPlaceID = null, $routingDate = null, $routeId = null, \ArrayType\ArrayOfInt $orders = null)
    {
        $this
            ->setDeliveryPlaceID($deliveryPlaceID)
            ->setRoutingDate($routingDate)
            ->setRouteId($routeId)
            ->setOrders($orders);
    }
    /**
     * Get DeliveryPlaceID value
     * @return int
     */
    public function getDeliveryPlaceID()
    {
        return $this->DeliveryPlaceID;
    }
    /**
     * Set DeliveryPlaceID value
     * @param int $deliveryPlaceID
     * @return \StructType\ExternalRoute
     */
    public function setDeliveryPlaceID($deliveryPlaceID = null)
    {
        // validation for constraint: int
        if (!is_null($deliveryPlaceID) && !(is_int($deliveryPlaceID) || ctype_digit($deliveryPlaceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deliveryPlaceID, true), gettype($deliveryPlaceID)), __LINE__);
        }
        $this->DeliveryPlaceID = $deliveryPlaceID;
        return $this;
    }
    /**
     * Get RoutingDate value
     * @return string
     */
    public function getRoutingDate()
    {
        return $this->RoutingDate;
    }
    /**
     * Set RoutingDate value
     * @param string $routingDate
     * @return \StructType\ExternalRoute
     */
    public function setRoutingDate($routingDate = null)
    {
        // validation for constraint: string
        if (!is_null($routingDate) && !is_string($routingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routingDate, true), gettype($routingDate)), __LINE__);
        }
        $this->RoutingDate = $routingDate;
        return $this;
    }
    /**
     * Get RouteId value
     * @return int
     */
    public function getRouteId()
    {
        return $this->RouteId;
    }
    /**
     * Set RouteId value
     * @param int $routeId
     * @return \StructType\ExternalRoute
     */
    public function setRouteId($routeId = null)
    {
        // validation for constraint: int
        if (!is_null($routeId) && !(is_int($routeId) || ctype_digit($routeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($routeId, true), gettype($routeId)), __LINE__);
        }
        $this->RouteId = $routeId;
        return $this;
    }
    /**
     * Get Orders value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getOrders()
    {
        return $this->Orders;
    }
    /**
     * Set Orders value
     * @param \ArrayType\ArrayOfInt $orders
     * @return \StructType\ExternalRoute
     */
    public function setOrders(\ArrayType\ArrayOfInt $orders = null)
    {
        $this->Orders = $orders;
        return $this;
    }
}
