<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegisterPickupPointResponse StructType
 * @subpackage Structs
 */
class RegisterPickupPointResponse extends Response
{
    /**
     * The PickupPointId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PickupPointId;
    /**
     * The RegisterPickupPointResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RegisterPickupPointResponse
     */
    public $RegisterPickupPointResult;
    /**
     * Constructor method for RegisterPickupPointResponse
     * @uses RegisterPickupPointResponse::setPickupPointId()
     * @uses RegisterPickupPointResponse::setRegisterPickupPointResult()
     * @param int $pickupPointId
     * @param \StructType\RegisterPickupPointResponse $registerPickupPointResult
     */
    public function __construct($pickupPointId = null, \StructType\RegisterPickupPointResponse $registerPickupPointResult = null)
    {
        $this
            ->setPickupPointId($pickupPointId)
            ->setRegisterPickupPointResult($registerPickupPointResult);
    }
    /**
     * Get PickupPointId value
     * @return int
     */
    public function getPickupPointId()
    {
        return $this->PickupPointId;
    }
    /**
     * Set PickupPointId value
     * @param int $pickupPointId
     * @return \StructType\RegisterPickupPointResponse
     */
    public function setPickupPointId($pickupPointId = null)
    {
        // validation for constraint: int
        if (!is_null($pickupPointId) && !(is_int($pickupPointId) || ctype_digit($pickupPointId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pickupPointId, true), gettype($pickupPointId)), __LINE__);
        }
        $this->PickupPointId = $pickupPointId;
        return $this;
    }
    /**
     * Get RegisterPickupPointResult value
     * @return \StructType\RegisterPickupPointResponse|null
     */
    public function getRegisterPickupPointResult()
    {
        return $this->RegisterPickupPointResult;
    }
    /**
     * Set RegisterPickupPointResult value
     * @param \StructType\RegisterPickupPointResponse $registerPickupPointResult
     * @return \StructType\RegisterPickupPointResponse
     */
    public function setRegisterPickupPointResult(\StructType\RegisterPickupPointResponse $registerPickupPointResult = null)
    {
        $this->RegisterPickupPointResult = $registerPickupPointResult;
        return $this;
    }
}
