<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PickupPoint StructType
 * @subpackage Structs
 */
class PickupPoint extends AbstractStructBase
{
    /**
     * The Latitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Longitude;
    /**
     * The TerminalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TerminalId;
    /**
     * The ExternalId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhoneNumber;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The OrganizationName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrganizationName;
    /**
     * The OrganizationINN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrganizationINN;
    /**
     * The TimeIntervalFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TimeIntervalFrom;
    /**
     * The TimeIntervalTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TimeIntervalTo;
    /**
     * The ContactPersonName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactPersonName;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * Constructor method for PickupPoint
     * @uses PickupPoint::setLatitude()
     * @uses PickupPoint::setLongitude()
     * @uses PickupPoint::setTerminalId()
     * @uses PickupPoint::setExternalId()
     * @uses PickupPoint::setName()
     * @uses PickupPoint::setPhoneNumber()
     * @uses PickupPoint::setAddress()
     * @uses PickupPoint::setOrganizationName()
     * @uses PickupPoint::setOrganizationINN()
     * @uses PickupPoint::setTimeIntervalFrom()
     * @uses PickupPoint::setTimeIntervalTo()
     * @uses PickupPoint::setContactPersonName()
     * @uses PickupPoint::setEmail()
     * @uses PickupPoint::setComment()
     * @param float $latitude
     * @param float $longitude
     * @param int $terminalId
     * @param string $externalId
     * @param string $name
     * @param string $phoneNumber
     * @param string $address
     * @param string $organizationName
     * @param string $organizationINN
     * @param string $timeIntervalFrom
     * @param string $timeIntervalTo
     * @param string $contactPersonName
     * @param string $email
     * @param string $comment
     */
    public function __construct($latitude = null, $longitude = null, $terminalId = null, $externalId = null, $name = null, $phoneNumber = null, $address = null, $organizationName = null, $organizationINN = null, $timeIntervalFrom = null, $timeIntervalTo = null, $contactPersonName = null, $email = null, $comment = null)
    {
        $this
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setTerminalId($terminalId)
            ->setExternalId($externalId)
            ->setName($name)
            ->setPhoneNumber($phoneNumber)
            ->setAddress($address)
            ->setOrganizationName($organizationName)
            ->setOrganizationINN($organizationINN)
            ->setTimeIntervalFrom($timeIntervalFrom)
            ->setTimeIntervalTo($timeIntervalTo)
            ->setContactPersonName($contactPersonName)
            ->setEmail($email)
            ->setComment($comment);
    }
    /**
     * Get Latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param float $latitude
     * @return \StructType\PickupPoint
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: float
        if (!is_null($latitude) && !(is_float($latitude) || is_numeric($latitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param float $longitude
     * @return \StructType\PickupPoint
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: float
        if (!is_null($longitude) && !(is_float($longitude) || is_numeric($longitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get TerminalId value
     * @return int
     */
    public function getTerminalId()
    {
        return $this->TerminalId;
    }
    /**
     * Set TerminalId value
     * @param int $terminalId
     * @return \StructType\PickupPoint
     */
    public function setTerminalId($terminalId = null)
    {
        // validation for constraint: int
        if (!is_null($terminalId) && !(is_int($terminalId) || ctype_digit($terminalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($terminalId, true), gettype($terminalId)), __LINE__);
        }
        $this->TerminalId = $terminalId;
        return $this;
    }
    /**
     * Get ExternalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->ExternalId;
    }
    /**
     * Set ExternalId value
     * @param string $externalId
     * @return \StructType\PickupPoint
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->ExternalId = $externalId;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\PickupPoint
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \StructType\PickupPoint
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\PickupPoint
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get OrganizationName value
     * @return string|null
     */
    public function getOrganizationName()
    {
        return $this->OrganizationName;
    }
    /**
     * Set OrganizationName value
     * @param string $organizationName
     * @return \StructType\PickupPoint
     */
    public function setOrganizationName($organizationName = null)
    {
        // validation for constraint: string
        if (!is_null($organizationName) && !is_string($organizationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationName, true), gettype($organizationName)), __LINE__);
        }
        $this->OrganizationName = $organizationName;
        return $this;
    }
    /**
     * Get OrganizationINN value
     * @return string|null
     */
    public function getOrganizationINN()
    {
        return $this->OrganizationINN;
    }
    /**
     * Set OrganizationINN value
     * @param string $organizationINN
     * @return \StructType\PickupPoint
     */
    public function setOrganizationINN($organizationINN = null)
    {
        // validation for constraint: string
        if (!is_null($organizationINN) && !is_string($organizationINN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationINN, true), gettype($organizationINN)), __LINE__);
        }
        $this->OrganizationINN = $organizationINN;
        return $this;
    }
    /**
     * Get TimeIntervalFrom value
     * @return string|null
     */
    public function getTimeIntervalFrom()
    {
        return $this->TimeIntervalFrom;
    }
    /**
     * Set TimeIntervalFrom value
     * @param string $timeIntervalFrom
     * @return \StructType\PickupPoint
     */
    public function setTimeIntervalFrom($timeIntervalFrom = null)
    {
        // validation for constraint: string
        if (!is_null($timeIntervalFrom) && !is_string($timeIntervalFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeIntervalFrom, true), gettype($timeIntervalFrom)), __LINE__);
        }
        $this->TimeIntervalFrom = $timeIntervalFrom;
        return $this;
    }
    /**
     * Get TimeIntervalTo value
     * @return string|null
     */
    public function getTimeIntervalTo()
    {
        return $this->TimeIntervalTo;
    }
    /**
     * Set TimeIntervalTo value
     * @param string $timeIntervalTo
     * @return \StructType\PickupPoint
     */
    public function setTimeIntervalTo($timeIntervalTo = null)
    {
        // validation for constraint: string
        if (!is_null($timeIntervalTo) && !is_string($timeIntervalTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeIntervalTo, true), gettype($timeIntervalTo)), __LINE__);
        }
        $this->TimeIntervalTo = $timeIntervalTo;
        return $this;
    }
    /**
     * Get ContactPersonName value
     * @return string|null
     */
    public function getContactPersonName()
    {
        return $this->ContactPersonName;
    }
    /**
     * Set ContactPersonName value
     * @param string $contactPersonName
     * @return \StructType\PickupPoint
     */
    public function setContactPersonName($contactPersonName = null)
    {
        // validation for constraint: string
        if (!is_null($contactPersonName) && !is_string($contactPersonName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactPersonName, true), gettype($contactPersonName)), __LINE__);
        }
        $this->ContactPersonName = $contactPersonName;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\PickupPoint
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\PickupPoint
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
}
