<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetItemStocks
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetItemStocks $parameters
     * @return \StructType\GetItemStocksResponse|bool
     */
    public function GetItemStocks(\StructType\GetItemStocks $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetItemStocks($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrdersStatusHistory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrdersStatusHistory $parameters
     * @return \StructType\GetOrdersStatusHistoryResponse|bool
     */
    public function GetOrdersStatusHistory(\StructType\GetOrdersStatusHistory $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrdersStatusHistory($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetInternetShopID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetInternetShopID $parameters
     * @return \StructType\GetInternetShopIDResponse|bool
     */
    public function GetInternetShopID(\StructType\GetInternetShopID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetInternetShopID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetShopsID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetShopsID $parameters
     * @return \StructType\GetShopsIDResponse|bool
     */
    public function GetShopsID(\StructType\GetShopsID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetShopsID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrder $parameters
     * @return \StructType\GetOrderResponse|bool
     */
    public function GetOrder(\StructType\GetOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSdOrderID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSdOrderID $parameters
     * @return \StructType\GetSdOrderIDResponse|bool
     */
    public function GetSdOrderID(\StructType\GetSdOrderID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSdOrderID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStatusOrders
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStatusOrders $parameters
     * @return \StructType\GetStatusOrdersResponse|bool
     */
    public function GetStatusOrders(\StructType\GetStatusOrders $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetStatusOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStatusOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStatusOrder $parameters
     * @return \StructType\GetStatusOrderResponse|bool
     */
    public function GetStatusOrder(\StructType\GetStatusOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetStatusOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStatusSdOrderID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStatusSdOrderID $parameters
     * @return \StructType\GetStatusSdOrderIDResponse|bool
     */
    public function GetStatusSdOrderID(\StructType\GetStatusSdOrderID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetStatusSdOrderID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStatusOrderByImportedID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStatusOrderByImportedID $parameters
     * @return \StructType\GetStatusOrderByImportedIDResponse|bool
     */
    public function GetStatusOrderByImportedID(\StructType\GetStatusOrderByImportedID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetStatusOrderByImportedID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNewOrders
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNewOrders $parameters
     * @return \StructType\GetNewOrdersResponse|bool
     */
    public function GetNewOrders(\StructType\GetNewOrders $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetNewOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrderStatusByStrizhOrderID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrderStatusByStrizhOrderID $parameters
     * @return \StructType\GetOrderStatusByStrizhOrderIDResponse|bool
     */
    public function GetOrderStatusByStrizhOrderID(\StructType\GetOrderStatusByStrizhOrderID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrderStatusByStrizhOrderID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrderStatusFByStrizhOrderID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrderStatusFByStrizhOrderID $parameters
     * @return \StructType\GetOrderStatusFByStrizhOrderIDResponse|bool
     */
    public function GetOrderStatusFByStrizhOrderID(\StructType\GetOrderStatusFByStrizhOrderID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrderStatusFByStrizhOrderID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrderInf
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrderInf $parameters
     * @return \StructType\GetOrderInfResponse|bool
     */
    public function GetOrderInf(\StructType\GetOrderInf $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrderInf($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetServicesCost
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetServicesCost $parameters
     * @return \StructType\GetServicesCostResponse|bool
     */
    public function GetServicesCost(\StructType\GetServicesCost $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetServicesCost($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCurrentStatuses
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCurrentStatuses $parameters
     * @return \StructType\GetCurrentStatusesResponse|bool
     */
    public function GetCurrentStatuses(\StructType\GetCurrentStatuses $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCurrentStatuses($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFinalStatuses
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFinalStatuses $parameters
     * @return \StructType\GetFinalStatusesResponse|bool
     */
    public function GetFinalStatuses(\StructType\GetFinalStatuses $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFinalStatuses($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCurStatusWithSetDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCurStatusWithSetDate $parameters
     * @return \StructType\GetCurStatusWithSetDateResponse|bool
     */
    public function GetCurStatusWithSetDate(\StructType\GetCurStatusWithSetDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCurStatusWithSetDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFinStatusWithSetDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFinStatusWithSetDate $parameters
     * @return \StructType\GetFinStatusWithSetDateResponse|bool
     */
    public function GetFinStatusWithSetDate(\StructType\GetFinStatusWithSetDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFinStatusWithSetDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRefusedOrderItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRefusedOrderItems $parameters
     * @return \StructType\GetRefusedOrderItemsResponse|bool
     */
    public function GetRefusedOrderItems(\StructType\GetRefusedOrderItems $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRefusedOrderItems($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSoldOrderItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSoldOrderItems $parameters
     * @return \StructType\GetSoldOrderItemsResponse|bool
     */
    public function GetSoldOrderItems(\StructType\GetSoldOrderItems $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSoldOrderItems($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetActiveTerminals
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetActiveTerminals $parameters
     * @return \StructType\GetActiveTerminalsResponse|bool
     */
    public function GetActiveTerminals(\StructType\GetActiveTerminals $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetActiveTerminals($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDeliveredOrders
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeliveredOrders $parameters
     * @return \StructType\GetDeliveredOrdersResponse|bool
     */
    public function GetDeliveredOrders(\StructType\GetDeliveredOrders $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDeliveredOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOpenDeliveredOrders
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOpenDeliveredOrders $parameters
     * @return \StructType\GetOpenDeliveredOrdersResponse|bool
     */
    public function GetOpenDeliveredOrders(\StructType\GetOpenDeliveredOrders $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOpenDeliveredOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrderStatusInit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrderStatusInit $parameters
     * @return \StructType\GetOrderStatusInitResponse|bool
     */
    public function GetOrderStatusInit(\StructType\GetOrderStatusInit $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrderStatusInit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTransCancelReasons
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTransCancelReasons $parameters
     * @return \StructType\GetTransCancelReasonsResponse|bool
     */
    public function GetTransCancelReasons(\StructType\GetTransCancelReasons $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTransCancelReasons($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrderTrack
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrderTrack $parameters
     * @return \StructType\GetOrderTrackResponse|bool
     */
    public function GetOrderTrack(\StructType\GetOrderTrack $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrderTrack($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrderPlaceInf
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrderPlaceInf $parameters
     * @return \StructType\GetOrderPlaceInfResponse|bool
     */
    public function GetOrderPlaceInf(\StructType\GetOrderPlaceInf $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrderPlaceInf($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDeliveryCost
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeliveryCost $parameters
     * @return \StructType\GetDeliveryCostResponse|bool
     */
    public function GetDeliveryCost(\StructType\GetDeliveryCost $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDeliveryCost($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetActiveTerminalsResponse|\StructType\GetCurrentStatusesResponse|\StructType\GetCurStatusWithSetDateResponse|\StructType\GetDeliveredOrdersResponse|\StructType\GetDeliveryCostResponse|\StructType\GetFinalStatusesResponse|\StructType\GetFinStatusWithSetDateResponse|\StructType\GetInternetShopIDResponse|\StructType\GetItemStocksResponse|\StructType\GetNewOrdersResponse|\StructType\GetOpenDeliveredOrdersResponse|\StructType\GetOrderInfResponse|\StructType\GetOrderPlaceInfResponse|\StructType\GetOrderResponse|\StructType\GetOrdersStatusHistoryResponse|\StructType\GetOrderStatusByStrizhOrderIDResponse|\StructType\GetOrderStatusFByStrizhOrderIDResponse|\StructType\GetOrderStatusInitResponse|\StructType\GetOrderTrackResponse|\StructType\GetRefusedOrderItemsResponse|\StructType\GetSdOrderIDResponse|\StructType\GetServicesCostResponse|\StructType\GetShopsIDResponse|\StructType\GetSoldOrderItemsResponse|\StructType\GetStatusOrderByImportedIDResponse|\StructType\GetStatusOrderResponse|\StructType\GetStatusOrdersResponse|\StructType\GetStatusSdOrderIDResponse|\StructType\GetTransCancelReasonsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
