<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CrewExternalRoute StructType
 * @subpackage Structs
 */
class CrewExternalRoute extends AbstractStructBase
{
    /**
     * The DeliveryPlaceID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeliveryPlaceID;
    /**
     * The RouteId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RouteId;
    /**
     * The RoutingDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RoutingDate;
    /**
     * The CarId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarId;
    /**
     * The CarBrand
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarBrand;
    /**
     * The CourierId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CourierId;
    /**
     * The CourierFullName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CourierFullName;
    /**
     * Constructor method for CrewExternalRoute
     * @uses CrewExternalRoute::setDeliveryPlaceID()
     * @uses CrewExternalRoute::setRouteId()
     * @uses CrewExternalRoute::setRoutingDate()
     * @uses CrewExternalRoute::setCarId()
     * @uses CrewExternalRoute::setCarBrand()
     * @uses CrewExternalRoute::setCourierId()
     * @uses CrewExternalRoute::setCourierFullName()
     * @param int $deliveryPlaceID
     * @param int $routeId
     * @param string $routingDate
     * @param string $carId
     * @param string $carBrand
     * @param string $courierId
     * @param string $courierFullName
     */
    public function __construct($deliveryPlaceID = null, $routeId = null, $routingDate = null, $carId = null, $carBrand = null, $courierId = null, $courierFullName = null)
    {
        $this
            ->setDeliveryPlaceID($deliveryPlaceID)
            ->setRouteId($routeId)
            ->setRoutingDate($routingDate)
            ->setCarId($carId)
            ->setCarBrand($carBrand)
            ->setCourierId($courierId)
            ->setCourierFullName($courierFullName);
    }
    /**
     * Get DeliveryPlaceID value
     * @return int
     */
    public function getDeliveryPlaceID()
    {
        return $this->DeliveryPlaceID;
    }
    /**
     * Set DeliveryPlaceID value
     * @param int $deliveryPlaceID
     * @return \StructType\CrewExternalRoute
     */
    public function setDeliveryPlaceID($deliveryPlaceID = null)
    {
        // validation for constraint: int
        if (!is_null($deliveryPlaceID) && !(is_int($deliveryPlaceID) || ctype_digit($deliveryPlaceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deliveryPlaceID, true), gettype($deliveryPlaceID)), __LINE__);
        }
        $this->DeliveryPlaceID = $deliveryPlaceID;
        return $this;
    }
    /**
     * Get RouteId value
     * @return int
     */
    public function getRouteId()
    {
        return $this->RouteId;
    }
    /**
     * Set RouteId value
     * @param int $routeId
     * @return \StructType\CrewExternalRoute
     */
    public function setRouteId($routeId = null)
    {
        // validation for constraint: int
        if (!is_null($routeId) && !(is_int($routeId) || ctype_digit($routeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($routeId, true), gettype($routeId)), __LINE__);
        }
        $this->RouteId = $routeId;
        return $this;
    }
    /**
     * Get RoutingDate value
     * @return string
     */
    public function getRoutingDate()
    {
        return $this->RoutingDate;
    }
    /**
     * Set RoutingDate value
     * @param string $routingDate
     * @return \StructType\CrewExternalRoute
     */
    public function setRoutingDate($routingDate = null)
    {
        // validation for constraint: string
        if (!is_null($routingDate) && !is_string($routingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routingDate, true), gettype($routingDate)), __LINE__);
        }
        $this->RoutingDate = $routingDate;
        return $this;
    }
    /**
     * Get CarId value
     * @return string|null
     */
    public function getCarId()
    {
        return $this->CarId;
    }
    /**
     * Set CarId value
     * @param string $carId
     * @return \StructType\CrewExternalRoute
     */
    public function setCarId($carId = null)
    {
        // validation for constraint: string
        if (!is_null($carId) && !is_string($carId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carId, true), gettype($carId)), __LINE__);
        }
        $this->CarId = $carId;
        return $this;
    }
    /**
     * Get CarBrand value
     * @return string|null
     */
    public function getCarBrand()
    {
        return $this->CarBrand;
    }
    /**
     * Set CarBrand value
     * @param string $carBrand
     * @return \StructType\CrewExternalRoute
     */
    public function setCarBrand($carBrand = null)
    {
        // validation for constraint: string
        if (!is_null($carBrand) && !is_string($carBrand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carBrand, true), gettype($carBrand)), __LINE__);
        }
        $this->CarBrand = $carBrand;
        return $this;
    }
    /**
     * Get CourierId value
     * @return string|null
     */
    public function getCourierId()
    {
        return $this->CourierId;
    }
    /**
     * Set CourierId value
     * @param string $courierId
     * @return \StructType\CrewExternalRoute
     */
    public function setCourierId($courierId = null)
    {
        // validation for constraint: string
        if (!is_null($courierId) && !is_string($courierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($courierId, true), gettype($courierId)), __LINE__);
        }
        $this->CourierId = $courierId;
        return $this;
    }
    /**
     * Get CourierFullName value
     * @return string|null
     */
    public function getCourierFullName()
    {
        return $this->CourierFullName;
    }
    /**
     * Set CourierFullName value
     * @param string $courierFullName
     * @return \StructType\CrewExternalRoute
     */
    public function setCourierFullName($courierFullName = null)
    {
        // validation for constraint: string
        if (!is_null($courierFullName) && !is_string($courierFullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($courierFullName, true), gettype($courierFullName)), __LINE__);
        }
        $this->CourierFullName = $courierFullName;
        return $this;
    }
}
