<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for User StructType
 * @subpackage Structs
 */
class User extends AbstractStructBase
{
    /**
     * The FIO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FIO;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * Constructor method for User
     * @uses User::setFIO()
     * @uses User::setPhone()
     * @uses User::setEmail()
     * @param string $fIO
     * @param string $phone
     * @param string $email
     */
    public function __construct($fIO = null, $phone = null, $email = null)
    {
        $this
            ->setFIO($fIO)
            ->setPhone($phone)
            ->setEmail($email);
    }
    /**
     * Get FIO value
     * @return string|null
     */
    public function getFIO()
    {
        return $this->FIO;
    }
    /**
     * Set FIO value
     * @param string $fIO
     * @return \StructType\User
     */
    public function setFIO($fIO = null)
    {
        // validation for constraint: string
        if (!is_null($fIO) && !is_string($fIO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fIO, true), gettype($fIO)), __LINE__);
        }
        $this->FIO = $fIO;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\User
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\User
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
}
