<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderDeliveryData StructType
 * @subpackage Structs
 */
class OrderDeliveryData extends AbstractStructBase
{
    /**
     * The DeliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DeliveryDate;
    /**
     * The TimeDeliveryFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TimeDeliveryFrom;
    /**
     * The TimeDeliveryTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TimeDeliveryTo;
    /**
     * Constructor method for OrderDeliveryData
     * @uses OrderDeliveryData::setDeliveryDate()
     * @uses OrderDeliveryData::setTimeDeliveryFrom()
     * @uses OrderDeliveryData::setTimeDeliveryTo()
     * @param string $deliveryDate
     * @param string $timeDeliveryFrom
     * @param string $timeDeliveryTo
     */
    public function __construct($deliveryDate = null, $timeDeliveryFrom = null, $timeDeliveryTo = null)
    {
        $this
            ->setDeliveryDate($deliveryDate)
            ->setTimeDeliveryFrom($timeDeliveryFrom)
            ->setTimeDeliveryTo($timeDeliveryTo);
    }
    /**
     * Get DeliveryDate value
     * @return string
     */
    public function getDeliveryDate()
    {
        return $this->DeliveryDate;
    }
    /**
     * Set DeliveryDate value
     * @param string $deliveryDate
     * @return \StructType\OrderDeliveryData
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        $this->DeliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get TimeDeliveryFrom value
     * @return string|null
     */
    public function getTimeDeliveryFrom()
    {
        return $this->TimeDeliveryFrom;
    }
    /**
     * Set TimeDeliveryFrom value
     * @param string $timeDeliveryFrom
     * @return \StructType\OrderDeliveryData
     */
    public function setTimeDeliveryFrom($timeDeliveryFrom = null)
    {
        // validation for constraint: string
        if (!is_null($timeDeliveryFrom) && !is_string($timeDeliveryFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeDeliveryFrom, true), gettype($timeDeliveryFrom)), __LINE__);
        }
        $this->TimeDeliveryFrom = $timeDeliveryFrom;
        return $this;
    }
    /**
     * Get TimeDeliveryTo value
     * @return string|null
     */
    public function getTimeDeliveryTo()
    {
        return $this->TimeDeliveryTo;
    }
    /**
     * Set TimeDeliveryTo value
     * @param string $timeDeliveryTo
     * @return \StructType\OrderDeliveryData
     */
    public function setTimeDeliveryTo($timeDeliveryTo = null)
    {
        // validation for constraint: string
        if (!is_null($timeDeliveryTo) && !is_string($timeDeliveryTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeDeliveryTo, true), gettype($timeDeliveryTo)), __LINE__);
        }
        $this->TimeDeliveryTo = $timeDeliveryTo;
        return $this;
    }
}
