<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ordersTableRow StructType
 * @subpackage Structs
 */
class OrdersTableRow extends AbstractStructBase
{
    /**
     * The orderID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $orderID;
    /**
     * The places
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $places;
    /**
     * The orderIDImport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $orderIDImport;
    /**
     * Constructor method for ordersTableRow
     * @uses OrdersTableRow::setOrderID()
     * @uses OrdersTableRow::setPlaces()
     * @uses OrdersTableRow::setOrderIDImport()
     * @param int $orderID
     * @param int $places
     * @param string $orderIDImport
     */
    public function __construct($orderID = null, $places = null, $orderIDImport = null)
    {
        $this
            ->setOrderID($orderID)
            ->setPlaces($places)
            ->setOrderIDImport($orderIDImport);
    }
    /**
     * Get orderID value
     * @return int
     */
    public function getOrderID()
    {
        return $this->orderID;
    }
    /**
     * Set orderID value
     * @param int $orderID
     * @return \StructType\OrdersTableRow
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: int
        if (!is_null($orderID) && !(is_int($orderID) || ctype_digit($orderID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->orderID = $orderID;
        return $this;
    }
    /**
     * Get places value
     * @return int
     */
    public function getPlaces()
    {
        return $this->places;
    }
    /**
     * Set places value
     * @param int $places
     * @return \StructType\OrdersTableRow
     */
    public function setPlaces($places = null)
    {
        // validation for constraint: int
        if (!is_null($places) && !(is_int($places) || ctype_digit($places))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($places, true), gettype($places)), __LINE__);
        }
        $this->places = $places;
        return $this;
    }
    /**
     * Get orderIDImport value
     * @return string|null
     */
    public function getOrderIDImport()
    {
        return $this->orderIDImport;
    }
    /**
     * Set orderIDImport value
     * @param string $orderIDImport
     * @return \StructType\OrdersTableRow
     */
    public function setOrderIDImport($orderIDImport = null)
    {
        // validation for constraint: string
        if (!is_null($orderIDImport) && !is_string($orderIDImport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderIDImport, true), gettype($orderIDImport)), __LINE__);
        }
        $this->orderIDImport = $orderIDImport;
        return $this;
    }
}
