<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Confirm ServiceType
 * @subpackage Services
 */
class Confirm extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ConfirmOrderPackaging
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConfirmOrderPackaging $parameters
     * @return \StructType\ConfirmOrderPackagingResponse|bool
     */
    public function ConfirmOrderPackaging(\StructType\ConfirmOrderPackaging $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConfirmOrderPackaging($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ConfirmOrderPackagingResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
