<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRefusedOrderItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfRefusedOrderItem extends AbstractStructArrayBase
{
    /**
     * The RefusedOrderItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RefusedOrderItem[]
     */
    public $RefusedOrderItem;
    /**
     * Constructor method for ArrayOfRefusedOrderItem
     * @uses ArrayOfRefusedOrderItem::setRefusedOrderItem()
     * @param \StructType\RefusedOrderItem[] $refusedOrderItem
     */
    public function __construct(array $refusedOrderItem = array())
    {
        $this
            ->setRefusedOrderItem($refusedOrderItem);
    }
    /**
     * Get RefusedOrderItem value
     * @return \StructType\RefusedOrderItem[]|null
     */
    public function getRefusedOrderItem()
    {
        return $this->RefusedOrderItem;
    }
    /**
     * This method is responsible for validating the values passed to the setRefusedOrderItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRefusedOrderItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRefusedOrderItemForArrayConstraintsFromSetRefusedOrderItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfRefusedOrderItemRefusedOrderItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfRefusedOrderItemRefusedOrderItemItem instanceof \StructType\RefusedOrderItem) {
                $invalidValues[] = is_object($arrayOfRefusedOrderItemRefusedOrderItemItem) ? get_class($arrayOfRefusedOrderItemRefusedOrderItemItem) : sprintf('%s(%s)', gettype($arrayOfRefusedOrderItemRefusedOrderItemItem), var_export($arrayOfRefusedOrderItemRefusedOrderItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RefusedOrderItem property can only contain items of type \StructType\RefusedOrderItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RefusedOrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\RefusedOrderItem[] $refusedOrderItem
     * @return \ArrayType\ArrayOfRefusedOrderItem
     */
    public function setRefusedOrderItem(array $refusedOrderItem = array())
    {
        // validation for constraint: array
        if ('' !== ($refusedOrderItemArrayErrorMessage = self::validateRefusedOrderItemForArrayConstraintsFromSetRefusedOrderItem($refusedOrderItem))) {
            throw new \InvalidArgumentException($refusedOrderItemArrayErrorMessage, __LINE__);
        }
        $this->RefusedOrderItem = $refusedOrderItem;
        return $this;
    }
    /**
     * Add item to RefusedOrderItem value
     * @throws \InvalidArgumentException
     * @param \StructType\RefusedOrderItem $item
     * @return \ArrayType\ArrayOfRefusedOrderItem
     */
    public function addToRefusedOrderItem(\StructType\RefusedOrderItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RefusedOrderItem) {
            throw new \InvalidArgumentException(sprintf('The RefusedOrderItem property can only contain items of type \StructType\RefusedOrderItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RefusedOrderItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RefusedOrderItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RefusedOrderItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RefusedOrderItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RefusedOrderItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RefusedOrderItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RefusedOrderItem
     */
    public function getAttributeName()
    {
        return 'RefusedOrderItem';
    }
}
