<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateDeliveOrderId StructType
 * @subpackage Structs
 */
class UpdateDeliveOrderId extends AbstractStructBase
{
    /**
     * The orderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $orderId;
    /**
     * The OuterDeliveId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OuterDeliveId;
    /**
     * The Auth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Authentication
     */
    public $Auth;
    /**
     * Constructor method for UpdateDeliveOrderId
     * @uses UpdateDeliveOrderId::setOrderId()
     * @uses UpdateDeliveOrderId::setOuterDeliveId()
     * @uses UpdateDeliveOrderId::setAuth()
     * @param int $orderId
     * @param string $outerDeliveId
     * @param \StructType\Authentication $auth
     */
    public function __construct($orderId = null, $outerDeliveId = null, \StructType\Authentication $auth = null)
    {
        $this
            ->setOrderId($orderId)
            ->setOuterDeliveId($outerDeliveId)
            ->setAuth($auth);
    }
    /**
     * Get orderId value
     * @return int
     */
    public function getOrderId()
    {
        return $this->orderId;
    }
    /**
     * Set orderId value
     * @param int $orderId
     * @return \StructType\UpdateDeliveOrderId
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: int
        if (!is_null($orderId) && !(is_int($orderId) || ctype_digit($orderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->orderId = $orderId;
        return $this;
    }
    /**
     * Get OuterDeliveId value
     * @return string|null
     */
    public function getOuterDeliveId()
    {
        return $this->OuterDeliveId;
    }
    /**
     * Set OuterDeliveId value
     * @param string $outerDeliveId
     * @return \StructType\UpdateDeliveOrderId
     */
    public function setOuterDeliveId($outerDeliveId = null)
    {
        // validation for constraint: string
        if (!is_null($outerDeliveId) && !is_string($outerDeliveId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($outerDeliveId, true), gettype($outerDeliveId)), __LINE__);
        }
        $this->OuterDeliveId = $outerDeliveId;
        return $this;
    }
    /**
     * Get Auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->Auth;
    }
    /**
     * Set Auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\UpdateDeliveOrderId
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->Auth = $auth;
        return $this;
    }
}
