<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateShopPhone StructType
 * @subpackage Structs
 */
class UpdateShopPhone extends AbstractStructBase
{
    /**
     * The settingId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $settingId;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $phone;
    /**
     * The Auth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Authentication
     */
    public $Auth;
    /**
     * Constructor method for UpdateShopPhone
     * @uses UpdateShopPhone::setSettingId()
     * @uses UpdateShopPhone::setPhone()
     * @uses UpdateShopPhone::setAuth()
     * @param int $settingId
     * @param string $phone
     * @param \StructType\Authentication $auth
     */
    public function __construct($settingId = null, $phone = null, \StructType\Authentication $auth = null)
    {
        $this
            ->setSettingId($settingId)
            ->setPhone($phone)
            ->setAuth($auth);
    }
    /**
     * Get settingId value
     * @return int
     */
    public function getSettingId()
    {
        return $this->settingId;
    }
    /**
     * Set settingId value
     * @param int $settingId
     * @return \StructType\UpdateShopPhone
     */
    public function setSettingId($settingId = null)
    {
        // validation for constraint: int
        if (!is_null($settingId) && !(is_int($settingId) || ctype_digit($settingId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($settingId, true), gettype($settingId)), __LINE__);
        }
        $this->settingId = $settingId;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \StructType\UpdateShopPhone
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get Auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->Auth;
    }
    /**
     * Set Auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\UpdateShopPhone
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->Auth = $auth;
        return $this;
    }
}
