<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetOrderTrack StructType
 * @subpackage Structs
 */
class GetOrderTrack extends AbstractStructBase
{
    /**
     * The settingId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $settingId;
    /**
     * The orderIdImport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $orderIdImport;
    /**
     * The Auth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Authentication
     */
    public $Auth;
    /**
     * Constructor method for GetOrderTrack
     * @uses GetOrderTrack::setSettingId()
     * @uses GetOrderTrack::setOrderIdImport()
     * @uses GetOrderTrack::setAuth()
     * @param int $settingId
     * @param string $orderIdImport
     * @param \StructType\Authentication $auth
     */
    public function __construct($settingId = null, $orderIdImport = null, \StructType\Authentication $auth = null)
    {
        $this
            ->setSettingId($settingId)
            ->setOrderIdImport($orderIdImport)
            ->setAuth($auth);
    }
    /**
     * Get settingId value
     * @return int
     */
    public function getSettingId()
    {
        return $this->settingId;
    }
    /**
     * Set settingId value
     * @param int $settingId
     * @return \StructType\GetOrderTrack
     */
    public function setSettingId($settingId = null)
    {
        // validation for constraint: int
        if (!is_null($settingId) && !(is_int($settingId) || ctype_digit($settingId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($settingId, true), gettype($settingId)), __LINE__);
        }
        $this->settingId = $settingId;
        return $this;
    }
    /**
     * Get orderIdImport value
     * @return string|null
     */
    public function getOrderIdImport()
    {
        return $this->orderIdImport;
    }
    /**
     * Set orderIdImport value
     * @param string $orderIdImport
     * @return \StructType\GetOrderTrack
     */
    public function setOrderIdImport($orderIdImport = null)
    {
        // validation for constraint: string
        if (!is_null($orderIdImport) && !is_string($orderIdImport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderIdImport, true), gettype($orderIdImport)), __LINE__);
        }
        $this->orderIdImport = $orderIdImport;
        return $this;
    }
    /**
     * Get Auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->Auth;
    }
    /**
     * Set Auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\GetOrderTrack
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->Auth = $auth;
        return $this;
    }
}
