<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOrderStatuses ArrayType
 * @subpackage Arrays
 */
class ArrayOfOrderStatuses extends AbstractStructArrayBase
{
    /**
     * The OrderStatuses
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OrderStatuses[]
     */
    public $OrderStatuses;
    /**
     * Constructor method for ArrayOfOrderStatuses
     * @uses ArrayOfOrderStatuses::setOrderStatuses()
     * @param \StructType\OrderStatuses[] $orderStatuses
     */
    public function __construct(array $orderStatuses = array())
    {
        $this
            ->setOrderStatuses($orderStatuses);
    }
    /**
     * Get OrderStatuses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OrderStatuses[]|null
     */
    public function getOrderStatuses()
    {
        return isset($this->OrderStatuses) ? $this->OrderStatuses : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderStatuses method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderStatuses method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderStatusesForArrayConstraintsFromSetOrderStatuses(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfOrderStatusesOrderStatusesItem) {
            // validation for constraint: itemType
            if (!$arrayOfOrderStatusesOrderStatusesItem instanceof \StructType\OrderStatuses) {
                $invalidValues[] = is_object($arrayOfOrderStatusesOrderStatusesItem) ? get_class($arrayOfOrderStatusesOrderStatusesItem) : sprintf('%s(%s)', gettype($arrayOfOrderStatusesOrderStatusesItem), var_export($arrayOfOrderStatusesOrderStatusesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderStatuses property can only contain items of type \StructType\OrderStatuses, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OrderStatuses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OrderStatuses[] $orderStatuses
     * @return \ArrayType\ArrayOfOrderStatuses
     */
    public function setOrderStatuses(array $orderStatuses = array())
    {
        // validation for constraint: array
        if ('' !== ($orderStatusesArrayErrorMessage = self::validateOrderStatusesForArrayConstraintsFromSetOrderStatuses($orderStatuses))) {
            throw new \InvalidArgumentException($orderStatusesArrayErrorMessage, __LINE__);
        }
        if (is_null($orderStatuses) || (is_array($orderStatuses) && empty($orderStatuses))) {
            unset($this->OrderStatuses);
        } else {
            $this->OrderStatuses = $orderStatuses;
        }
        return $this;
    }
    /**
     * Add item to OrderStatuses value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderStatuses $item
     * @return \ArrayType\ArrayOfOrderStatuses
     */
    public function addToOrderStatuses(\StructType\OrderStatuses $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderStatuses) {
            throw new \InvalidArgumentException(sprintf('The OrderStatuses property can only contain items of type \StructType\OrderStatuses, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderStatuses[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\OrderStatuses|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\OrderStatuses|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\OrderStatuses|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\OrderStatuses|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\OrderStatuses|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OrderStatuses
     */
    public function getAttributeName()
    {
        return 'OrderStatuses';
    }
}
