<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AddItemsToOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddItemsToOrder $parameters
     * @return \StructType\AddItemsToOrderResponse|bool
     */
    public function AddItemsToOrder(\StructType\AddItemsToOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddItemsToOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddLogo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddLogo $parameters
     * @return \StructType\AddLogoResponse|bool
     */
    public function AddLogo(\StructType\AddLogo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddLogo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddAcceptanceReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddAcceptanceReport $parameters
     * @return \StructType\AddAcceptanceReportResponse|bool
     */
    public function AddAcceptanceReport(\StructType\AddAcceptanceReport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddAcceptanceReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddCarriage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AddCarriage $parameters
     * @return \StructType\AddCarriageResponse|bool
     */
    public function AddCarriage(\StructType\AddCarriage $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AddCarriage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AddAcceptanceReportResponse|\StructType\AddCarriageResponse|\StructType\AddItemsToOrderResponse|\StructType\AddLogoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
