<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDeliveredOrders StructType
 * @subpackage Structs
 */
class GetDeliveredOrders extends AbstractStructBase
{
    /**
     * The dateFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $dateFrom;
    /**
     * The dateTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $dateTo;
    /**
     * The settingId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $settingId;
    /**
     * The Auth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Authentication
     */
    public $Auth;
    /**
     * Constructor method for GetDeliveredOrders
     * @uses GetDeliveredOrders::setDateFrom()
     * @uses GetDeliveredOrders::setDateTo()
     * @uses GetDeliveredOrders::setSettingId()
     * @uses GetDeliveredOrders::setAuth()
     * @param string $dateFrom
     * @param string $dateTo
     * @param int $settingId
     * @param \StructType\Authentication $auth
     */
    public function __construct($dateFrom = null, $dateTo = null, $settingId = null, \StructType\Authentication $auth = null)
    {
        $this
            ->setDateFrom($dateFrom)
            ->setDateTo($dateTo)
            ->setSettingId($settingId)
            ->setAuth($auth);
    }
    /**
     * Get dateFrom value
     * @return string
     */
    public function getDateFrom()
    {
        return $this->dateFrom;
    }
    /**
     * Set dateFrom value
     * @param string $dateFrom
     * @return \StructType\GetDeliveredOrders
     */
    public function setDateFrom($dateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($dateFrom) && !is_string($dateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateFrom, true), gettype($dateFrom)), __LINE__);
        }
        $this->dateFrom = $dateFrom;
        return $this;
    }
    /**
     * Get dateTo value
     * @return string
     */
    public function getDateTo()
    {
        return $this->dateTo;
    }
    /**
     * Set dateTo value
     * @param string $dateTo
     * @return \StructType\GetDeliveredOrders
     */
    public function setDateTo($dateTo = null)
    {
        // validation for constraint: string
        if (!is_null($dateTo) && !is_string($dateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTo, true), gettype($dateTo)), __LINE__);
        }
        $this->dateTo = $dateTo;
        return $this;
    }
    /**
     * Get settingId value
     * @return int
     */
    public function getSettingId()
    {
        return $this->settingId;
    }
    /**
     * Set settingId value
     * @param int $settingId
     * @return \StructType\GetDeliveredOrders
     */
    public function setSettingId($settingId = null)
    {
        // validation for constraint: int
        if (!is_null($settingId) && !(is_int($settingId) || ctype_digit($settingId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($settingId, true), gettype($settingId)), __LINE__);
        }
        $this->settingId = $settingId;
        return $this;
    }
    /**
     * Get Auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->Auth;
    }
    /**
     * Set Auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\GetDeliveredOrders
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->Auth = $auth;
        return $this;
    }
}
