<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemStock StructType
 * @subpackage Structs
 */
class ItemStock extends AbstractStructBase
{
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Price;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActive;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Stocks
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfStock
     */
    public $Stocks;
    /**
     * Constructor method for ItemStock
     * @uses ItemStock::setPrice()
     * @uses ItemStock::setIsActive()
     * @uses ItemStock::setCode()
     * @uses ItemStock::setStocks()
     * @param float $price
     * @param bool $isActive
     * @param string $code
     * @param \ArrayType\ArrayOfStock $stocks
     */
    public function __construct($price = null, $isActive = null, $code = null, \ArrayType\ArrayOfStock $stocks = null)
    {
        $this
            ->setPrice($price)
            ->setIsActive($isActive)
            ->setCode($code)
            ->setStocks($stocks);
    }
    /**
     * Get Price value
     * @return float
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\ItemStock
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \StructType\ItemStock
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\ItemStock
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Stocks value
     * @return \ArrayType\ArrayOfStock|null
     */
    public function getStocks()
    {
        return $this->Stocks;
    }
    /**
     * Set Stocks value
     * @param \ArrayType\ArrayOfStock $stocks
     * @return \StructType\ItemStock
     */
    public function setStocks(\ArrayType\ArrayOfStock $stocks = null)
    {
        $this->Stocks = $stocks;
        return $this;
    }
}
