<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegisterUser StructType
 * @subpackage Structs
 */
class RegisterUser extends AbstractStructBase
{
    /**
     * The user
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ImpUser
     */
    public $user;
    /**
     * The Auth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Authentication
     */
    public $Auth;
    /**
     * Constructor method for RegisterUser
     * @uses RegisterUser::setUser()
     * @uses RegisterUser::setAuth()
     * @param \StructType\ImpUser $user
     * @param \StructType\Authentication $auth
     */
    public function __construct(\StructType\ImpUser $user = null, \StructType\Authentication $auth = null)
    {
        $this
            ->setUser($user)
            ->setAuth($auth);
    }
    /**
     * Get user value
     * @return \StructType\ImpUser|null
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param \StructType\ImpUser $user
     * @return \StructType\RegisterUser
     */
    public function setUser(\StructType\ImpUser $user = null)
    {
        $this->user = $user;
        return $this;
    }
    /**
     * Get Auth value
     * @return \StructType\Authentication|null
     */
    public function getAuth()
    {
        return $this->Auth;
    }
    /**
     * Set Auth value
     * @param \StructType\Authentication $auth
     * @return \StructType\RegisterUser
     */
    public function setAuth(\StructType\Authentication $auth = null)
    {
        $this->Auth = $auth;
        return $this;
    }
}
