<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StatusChange StructType
 * @subpackage Structs
 */
class StatusChange extends AbstractStructBase
{
    /**
     * The StatusId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $StatusId;
    /**
     * The FinalStatusId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FinalStatusId;
    /**
     * Constructor method for StatusChange
     * @uses StatusChange::setStatusId()
     * @uses StatusChange::setFinalStatusId()
     * @param int $statusId
     * @param int $finalStatusId
     */
    public function __construct($statusId = null, $finalStatusId = null)
    {
        $this
            ->setStatusId($statusId)
            ->setFinalStatusId($finalStatusId);
    }
    /**
     * Get StatusId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getStatusId()
    {
        return isset($this->StatusId) ? $this->StatusId : null;
    }
    /**
     * Set StatusId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $statusId
     * @return \StructType\StatusChange
     */
    public function setStatusId($statusId = null)
    {
        // validation for constraint: int
        if (!is_null($statusId) && !(is_int($statusId) || ctype_digit($statusId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusId, true), gettype($statusId)), __LINE__);
        }
        if (is_null($statusId) || (is_array($statusId) && empty($statusId))) {
            unset($this->StatusId);
        } else {
            $this->StatusId = $statusId;
        }
        return $this;
    }
    /**
     * Get FinalStatusId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFinalStatusId()
    {
        return isset($this->FinalStatusId) ? $this->FinalStatusId : null;
    }
    /**
     * Set FinalStatusId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $finalStatusId
     * @return \StructType\StatusChange
     */
    public function setFinalStatusId($finalStatusId = null)
    {
        // validation for constraint: int
        if (!is_null($finalStatusId) && !(is_int($finalStatusId) || ctype_digit($finalStatusId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($finalStatusId, true), gettype($finalStatusId)), __LINE__);
        }
        if (is_null($finalStatusId) || (is_array($finalStatusId) && empty($finalStatusId))) {
            unset($this->FinalStatusId);
        } else {
            $this->FinalStatusId = $finalStatusId;
        }
        return $this;
    }
}
