<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item StructType
 * @subpackage Structs
 */
class Item extends AbstractStructBase
{
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Category;
    /**
     * The Count
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Count;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Price;
    /**
     * The NDS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NDS;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Brand
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Brand;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Article
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Article;
    /**
     * The AssessedCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AssessedCost;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Barcode;
    /**
     * The BarcodePackage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BarcodePackage;
    /**
     * The MarkingCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MarkingCode;
    /**
     * The OrderItemType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderItemType;
    /**
     * The SellerInn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SellerInn;
    /**
     * The SellerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SellerName;
    /**
     * The SellerPhone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SellerPhone;
    /**
     * Constructor method for Item
     * @uses Item::setCategory()
     * @uses Item::setCount()
     * @uses Item::setPrice()
     * @uses Item::setNDS()
     * @uses Item::setCode()
     * @uses Item::setName()
     * @uses Item::setBrand()
     * @uses Item::setDescription()
     * @uses Item::setArticle()
     * @uses Item::setAssessedCost()
     * @uses Item::setBarcode()
     * @uses Item::setBarcodePackage()
     * @uses Item::setMarkingCode()
     * @uses Item::setOrderItemType()
     * @uses Item::setSellerInn()
     * @uses Item::setSellerName()
     * @uses Item::setSellerPhone()
     * @param int $category
     * @param int $count
     * @param float $price
     * @param int $nDS
     * @param string $code
     * @param string $name
     * @param string $brand
     * @param string $description
     * @param string $article
     * @param float $assessedCost
     * @param string $barcode
     * @param string $barcodePackage
     * @param string $markingCode
     * @param string $orderItemType
     * @param string $sellerInn
     * @param string $sellerName
     * @param string $sellerPhone
     */
    public function __construct($category = null, $count = null, $price = null, $nDS = null, $code = null, $name = null, $brand = null, $description = null, $article = null, $assessedCost = null, $barcode = null, $barcodePackage = null, $markingCode = null, $orderItemType = null, $sellerInn = null, $sellerName = null, $sellerPhone = null)
    {
        $this
            ->setCategory($category)
            ->setCount($count)
            ->setPrice($price)
            ->setNDS($nDS)
            ->setCode($code)
            ->setName($name)
            ->setBrand($brand)
            ->setDescription($description)
            ->setArticle($article)
            ->setAssessedCost($assessedCost)
            ->setBarcode($barcode)
            ->setBarcodePackage($barcodePackage)
            ->setMarkingCode($markingCode)
            ->setOrderItemType($orderItemType)
            ->setSellerInn($sellerInn)
            ->setSellerName($sellerName)
            ->setSellerPhone($sellerPhone);
    }
    /**
     * Get Category value
     * @return int
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param int $category
     * @return \StructType\Item
     */
    public function setCategory($category = null)
    {
        // validation for constraint: int
        if (!is_null($category) && !(is_int($category) || ctype_digit($category))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get Count value
     * @return int
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param int $count
     * @return \StructType\Item
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->Count = $count;
        return $this;
    }
    /**
     * Get Price value
     * @return float
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\Item
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get NDS value
     * @return int
     */
    public function getNDS()
    {
        return $this->NDS;
    }
    /**
     * Set NDS value
     * @param int $nDS
     * @return \StructType\Item
     */
    public function setNDS($nDS = null)
    {
        // validation for constraint: int
        if (!is_null($nDS) && !(is_int($nDS) || ctype_digit($nDS))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nDS, true), gettype($nDS)), __LINE__);
        }
        $this->NDS = $nDS;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\Item
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Item
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Brand value
     * @return string|null
     */
    public function getBrand()
    {
        return $this->Brand;
    }
    /**
     * Set Brand value
     * @param string $brand
     * @return \StructType\Item
     */
    public function setBrand($brand = null)
    {
        // validation for constraint: string
        if (!is_null($brand) && !is_string($brand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brand, true), gettype($brand)), __LINE__);
        }
        $this->Brand = $brand;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Item
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Article value
     * @return string|null
     */
    public function getArticle()
    {
        return $this->Article;
    }
    /**
     * Set Article value
     * @param string $article
     * @return \StructType\Item
     */
    public function setArticle($article = null)
    {
        // validation for constraint: string
        if (!is_null($article) && !is_string($article)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($article, true), gettype($article)), __LINE__);
        }
        $this->Article = $article;
        return $this;
    }
    /**
     * Get AssessedCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAssessedCost()
    {
        return isset($this->AssessedCost) ? $this->AssessedCost : null;
    }
    /**
     * Set AssessedCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $assessedCost
     * @return \StructType\Item
     */
    public function setAssessedCost($assessedCost = null)
    {
        // validation for constraint: float
        if (!is_null($assessedCost) && !(is_float($assessedCost) || is_numeric($assessedCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($assessedCost, true), gettype($assessedCost)), __LINE__);
        }
        if (is_null($assessedCost) || (is_array($assessedCost) && empty($assessedCost))) {
            unset($this->AssessedCost);
        } else {
            $this->AssessedCost = $assessedCost;
        }
        return $this;
    }
    /**
     * Get Barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }
    /**
     * Set Barcode value
     * @param string $barcode
     * @return \StructType\Item
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        $this->Barcode = $barcode;
        return $this;
    }
    /**
     * Get BarcodePackage value
     * @return string|null
     */
    public function getBarcodePackage()
    {
        return $this->BarcodePackage;
    }
    /**
     * Set BarcodePackage value
     * @param string $barcodePackage
     * @return \StructType\Item
     */
    public function setBarcodePackage($barcodePackage = null)
    {
        // validation for constraint: string
        if (!is_null($barcodePackage) && !is_string($barcodePackage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodePackage, true), gettype($barcodePackage)), __LINE__);
        }
        $this->BarcodePackage = $barcodePackage;
        return $this;
    }
    /**
     * Get MarkingCode value
     * @return string|null
     */
    public function getMarkingCode()
    {
        return $this->MarkingCode;
    }
    /**
     * Set MarkingCode value
     * @param string $markingCode
     * @return \StructType\Item
     */
    public function setMarkingCode($markingCode = null)
    {
        // validation for constraint: string
        if (!is_null($markingCode) && !is_string($markingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($markingCode, true), gettype($markingCode)), __LINE__);
        }
        $this->MarkingCode = $markingCode;
        return $this;
    }
    /**
     * Get OrderItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderItemType()
    {
        return isset($this->OrderItemType) ? $this->OrderItemType : null;
    }
    /**
     * Set OrderItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderItemType
     * @return \StructType\Item
     */
    public function setOrderItemType($orderItemType = null)
    {
        // validation for constraint: string
        if (!is_null($orderItemType) && !is_string($orderItemType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderItemType, true), gettype($orderItemType)), __LINE__);
        }
        if (is_null($orderItemType) || (is_array($orderItemType) && empty($orderItemType))) {
            unset($this->OrderItemType);
        } else {
            $this->OrderItemType = $orderItemType;
        }
        return $this;
    }
    /**
     * Get SellerInn value
     * @return string|null
     */
    public function getSellerInn()
    {
        return $this->SellerInn;
    }
    /**
     * Set SellerInn value
     * @param string $sellerInn
     * @return \StructType\Item
     */
    public function setSellerInn($sellerInn = null)
    {
        // validation for constraint: string
        if (!is_null($sellerInn) && !is_string($sellerInn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerInn, true), gettype($sellerInn)), __LINE__);
        }
        $this->SellerInn = $sellerInn;
        return $this;
    }
    /**
     * Get SellerName value
     * @return string|null
     */
    public function getSellerName()
    {
        return $this->SellerName;
    }
    /**
     * Set SellerName value
     * @param string $sellerName
     * @return \StructType\Item
     */
    public function setSellerName($sellerName = null)
    {
        // validation for constraint: string
        if (!is_null($sellerName) && !is_string($sellerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerName, true), gettype($sellerName)), __LINE__);
        }
        $this->SellerName = $sellerName;
        return $this;
    }
    /**
     * Get SellerPhone value
     * @return string|null
     */
    public function getSellerPhone()
    {
        return $this->SellerPhone;
    }
    /**
     * Set SellerPhone value
     * @param string $sellerPhone
     * @return \StructType\Item
     */
    public function setSellerPhone($sellerPhone = null)
    {
        // validation for constraint: string
        if (!is_null($sellerPhone) && !is_string($sellerPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerPhone, true), gettype($sellerPhone)), __LINE__);
        }
        $this->SellerPhone = $sellerPhone;
        return $this;
    }
}
