<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfItemStock ArrayType
 * @subpackage Arrays
 */
class ArrayOfItemStock extends AbstractStructArrayBase
{
    /**
     * The ItemStock
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ItemStock[]
     */
    public $ItemStock;
    /**
     * Constructor method for ArrayOfItemStock
     * @uses ArrayOfItemStock::setItemStock()
     * @param \StructType\ItemStock[] $itemStock
     */
    public function __construct(array $itemStock = array())
    {
        $this
            ->setItemStock($itemStock);
    }
    /**
     * Get ItemStock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ItemStock[]|null
     */
    public function getItemStock()
    {
        return isset($this->ItemStock) ? $this->ItemStock : null;
    }
    /**
     * This method is responsible for validating the values passed to the setItemStock method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemStock method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemStockForArrayConstraintsFromSetItemStock(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfItemStockItemStockItem) {
            // validation for constraint: itemType
            if (!$arrayOfItemStockItemStockItem instanceof \StructType\ItemStock) {
                $invalidValues[] = is_object($arrayOfItemStockItemStockItem) ? get_class($arrayOfItemStockItemStockItem) : sprintf('%s(%s)', gettype($arrayOfItemStockItemStockItem), var_export($arrayOfItemStockItemStockItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemStock property can only contain items of type \StructType\ItemStock, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemStock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ItemStock[] $itemStock
     * @return \ArrayType\ArrayOfItemStock
     */
    public function setItemStock(array $itemStock = array())
    {
        // validation for constraint: array
        if ('' !== ($itemStockArrayErrorMessage = self::validateItemStockForArrayConstraintsFromSetItemStock($itemStock))) {
            throw new \InvalidArgumentException($itemStockArrayErrorMessage, __LINE__);
        }
        if (is_null($itemStock) || (is_array($itemStock) && empty($itemStock))) {
            unset($this->ItemStock);
        } else {
            $this->ItemStock = $itemStock;
        }
        return $this;
    }
    /**
     * Add item to ItemStock value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemStock $item
     * @return \ArrayType\ArrayOfItemStock
     */
    public function addToItemStock(\StructType\ItemStock $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemStock) {
            throw new \InvalidArgumentException(sprintf('The ItemStock property can only contain items of type \StructType\ItemStock, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemStock[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ItemStock|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ItemStock|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ItemStock|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ItemStock|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ItemStock|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ItemStock
     */
    public function getAttributeName()
    {
        return 'ItemStock';
    }
}
