<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for responseData StructType
 * @subpackage Structs
 */
class ResponseData extends AbstractStructBase
{
    /**
     * The pickingItemStringID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pickingItemStringID;
    /**
     * The text
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $text;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * Constructor method for responseData
     * @uses ResponseData::setPickingItemStringID()
     * @uses ResponseData::setText()
     * @uses ResponseData::setType()
     * @param string $pickingItemStringID
     * @param string $text
     * @param string $type
     */
    public function __construct($pickingItemStringID = null, $text = null, $type = null)
    {
        $this
            ->setPickingItemStringID($pickingItemStringID)
            ->setText($text)
            ->setType($type);
    }
    /**
     * Get pickingItemStringID value
     * @return string|null
     */
    public function getPickingItemStringID()
    {
        return $this->pickingItemStringID;
    }
    /**
     * Set pickingItemStringID value
     * @param string $pickingItemStringID
     * @return \StructType\ResponseData
     */
    public function setPickingItemStringID($pickingItemStringID = null)
    {
        // validation for constraint: string
        if (!is_null($pickingItemStringID) && !is_string($pickingItemStringID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickingItemStringID, true), gettype($pickingItemStringID)), __LINE__);
        }
        $this->pickingItemStringID = $pickingItemStringID;
        return $this;
    }
    /**
     * Get text value
     * @return string|null
     */
    public function getText()
    {
        return $this->text;
    }
    /**
     * Set text value
     * @param string $text
     * @return \StructType\ResponseData
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        $this->text = $text;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\ResponseData
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResponseData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
