<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegisterWarehouseResponse StructType
 * @subpackage Structs
 */
class RegisterWarehouseResponse extends Response
{
    /**
     * The StockId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $StockId;
    /**
     * The RegisterWarehouseResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RegisterWarehouseResponse
     */
    public $RegisterWarehouseResult;
    /**
     * Constructor method for RegisterWarehouseResponse
     * @uses RegisterWarehouseResponse::setStockId()
     * @uses RegisterWarehouseResponse::setRegisterWarehouseResult()
     * @param int $stockId
     * @param \StructType\RegisterWarehouseResponse $registerWarehouseResult
     */
    public function __construct($stockId = null, \StructType\RegisterWarehouseResponse $registerWarehouseResult = null)
    {
        $this
            ->setStockId($stockId)
            ->setRegisterWarehouseResult($registerWarehouseResult);
    }
    /**
     * Get StockId value
     * @return int
     */
    public function getStockId()
    {
        return $this->StockId;
    }
    /**
     * Set StockId value
     * @param int $stockId
     * @return \StructType\RegisterWarehouseResponse
     */
    public function setStockId($stockId = null)
    {
        // validation for constraint: int
        if (!is_null($stockId) && !(is_int($stockId) || ctype_digit($stockId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stockId, true), gettype($stockId)), __LINE__);
        }
        $this->StockId = $stockId;
        return $this;
    }
    /**
     * Get RegisterWarehouseResult value
     * @return \StructType\RegisterWarehouseResponse|null
     */
    public function getRegisterWarehouseResult()
    {
        return $this->RegisterWarehouseResult;
    }
    /**
     * Set RegisterWarehouseResult value
     * @param \StructType\RegisterWarehouseResponse $registerWarehouseResult
     * @return \StructType\RegisterWarehouseResponse
     */
    public function setRegisterWarehouseResult(\StructType\RegisterWarehouseResponse $registerWarehouseResult = null)
    {
        $this->RegisterWarehouseResult = $registerWarehouseResult;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RegisterWarehouseResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
