<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addedShop StructType
 * @subpackage Structs
 */
class AddedShop extends AbstractStructBase
{
    /**
     * The internetShopID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $internetShopID;
    /**
     * The settingID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $settingID;
    /**
     * Constructor method for addedShop
     * @uses AddedShop::setInternetShopID()
     * @uses AddedShop::setSettingID()
     * @param int $internetShopID
     * @param int $settingID
     */
    public function __construct($internetShopID = null, $settingID = null)
    {
        $this
            ->setInternetShopID($internetShopID)
            ->setSettingID($settingID);
    }
    /**
     * Get internetShopID value
     * @return int
     */
    public function getInternetShopID()
    {
        return $this->internetShopID;
    }
    /**
     * Set internetShopID value
     * @param int $internetShopID
     * @return \StructType\AddedShop
     */
    public function setInternetShopID($internetShopID = null)
    {
        // validation for constraint: int
        if (!is_null($internetShopID) && !(is_int($internetShopID) || ctype_digit($internetShopID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($internetShopID, true), gettype($internetShopID)), __LINE__);
        }
        $this->internetShopID = $internetShopID;
        return $this;
    }
    /**
     * Get settingID value
     * @return int
     */
    public function getSettingID()
    {
        return $this->settingID;
    }
    /**
     * Set settingID value
     * @param int $settingID
     * @return \StructType\AddedShop
     */
    public function setSettingID($settingID = null)
    {
        // validation for constraint: int
        if (!is_null($settingID) && !(is_int($settingID) || ctype_digit($settingID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($settingID, true), gettype($settingID)), __LINE__);
        }
        $this->settingID = $settingID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddedShop
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
