<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for carriage StructType
 * @subpackage Structs
 */
class Carriage extends AbstractStructBase
{
    /**
     * The date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $date;
    /**
     * The stockId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $stockId;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $number;
    /**
     * The parcels
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfParcel
     */
    public $parcels;
    /**
     * Constructor method for carriage
     * @uses Carriage::setDate()
     * @uses Carriage::setStockId()
     * @uses Carriage::setNumber()
     * @uses Carriage::setParcels()
     * @param string $date
     * @param string $stockId
     * @param string $number
     * @param \ArrayType\ArrayOfParcel $parcels
     */
    public function __construct($date = null, $stockId = null, $number = null, \ArrayType\ArrayOfParcel $parcels = null)
    {
        $this
            ->setDate($date)
            ->setStockId($stockId)
            ->setNumber($number)
            ->setParcels($parcels);
    }
    /**
     * Get date value
     * @return string
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\Carriage
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get stockId value
     * @return string
     */
    public function getStockId()
    {
        return $this->stockId;
    }
    /**
     * Set stockId value
     * @param string $stockId
     * @return \StructType\Carriage
     */
    public function setStockId($stockId = null)
    {
        // validation for constraint: string
        if (!is_null($stockId) && !is_string($stockId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stockId, true), gettype($stockId)), __LINE__);
        }
        $this->stockId = $stockId;
        return $this;
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\Carriage
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get parcels value
     * @return \ArrayType\ArrayOfParcel|null
     */
    public function getParcels()
    {
        return $this->parcels;
    }
    /**
     * Set parcels value
     * @param \ArrayType\ArrayOfParcel $parcels
     * @return \StructType\Carriage
     */
    public function setParcels(\ArrayType\ArrayOfParcel $parcels = null)
    {
        $this->parcels = $parcels;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Carriage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
