<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderStatus StructType
 * @subpackage Structs
 */
class OrderStatus extends AbstractStructBase
{
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $status;
    /**
     * The ReasonRrefusal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReasonRrefusal;
    /**
     * The CarNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CarNumber;
    /**
     * The DriverPhone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DriverPhone;
    /**
     * Constructor method for OrderStatus
     * @uses OrderStatus::setStatus()
     * @uses OrderStatus::setReasonRrefusal()
     * @uses OrderStatus::setCarNumber()
     * @uses OrderStatus::setDriverPhone()
     * @param int $status
     * @param string $reasonRrefusal
     * @param string $carNumber
     * @param string $driverPhone
     */
    public function __construct($status = null, $reasonRrefusal = null, $carNumber = null, $driverPhone = null)
    {
        $this
            ->setStatus($status)
            ->setReasonRrefusal($reasonRrefusal)
            ->setCarNumber($carNumber)
            ->setDriverPhone($driverPhone);
    }
    /**
     * Get status value
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \StructType\OrderStatus
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get ReasonRrefusal value
     * @return string|null
     */
    public function getReasonRrefusal()
    {
        return $this->ReasonRrefusal;
    }
    /**
     * Set ReasonRrefusal value
     * @param string $reasonRrefusal
     * @return \StructType\OrderStatus
     */
    public function setReasonRrefusal($reasonRrefusal = null)
    {
        // validation for constraint: string
        if (!is_null($reasonRrefusal) && !is_string($reasonRrefusal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonRrefusal, true), gettype($reasonRrefusal)), __LINE__);
        }
        $this->ReasonRrefusal = $reasonRrefusal;
        return $this;
    }
    /**
     * Get CarNumber value
     * @return string|null
     */
    public function getCarNumber()
    {
        return $this->CarNumber;
    }
    /**
     * Set CarNumber value
     * @param string $carNumber
     * @return \StructType\OrderStatus
     */
    public function setCarNumber($carNumber = null)
    {
        // validation for constraint: string
        if (!is_null($carNumber) && !is_string($carNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carNumber, true), gettype($carNumber)), __LINE__);
        }
        $this->CarNumber = $carNumber;
        return $this;
    }
    /**
     * Get DriverPhone value
     * @return string|null
     */
    public function getDriverPhone()
    {
        return $this->DriverPhone;
    }
    /**
     * Set DriverPhone value
     * @param string $driverPhone
     * @return \StructType\OrderStatus
     */
    public function setDriverPhone($driverPhone = null)
    {
        // validation for constraint: string
        if (!is_null($driverPhone) && !is_string($driverPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverPhone, true), gettype($driverPhone)), __LINE__);
        }
        $this->DriverPhone = $driverPhone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
