<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImpOrder StructType
 * @subpackage Structs
 */
class ImpOrder extends AbstractStructBase
{
    /**
     * The orderID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $orderID;
    /**
     * The userID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $userID;
    /**
     * The completeDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $completeDate;
    /**
     * The deliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $deliveryDate;
    /**
     * The IsRefusalWithDelivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsRefusalWithDelivery;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $status;
    /**
     * The orderRBSStateID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $orderRBSStateID;
    /**
     * The paytype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $paytype;
    /**
     * The modifyDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $modifyDate;
    /**
     * The SumByCard
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SumByCard;
    /**
     * The typeDelivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $typeDelivery;
    /**
     * The ServiceDelivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ServiceDelivery;
    /**
     * The PiecesOfFreight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PiecesOfFreight;
    /**
     * The userAddressID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $userAddressID;
    /**
     * The SettingID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SettingID;
    /**
     * The selfDelivery
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $selfDelivery;
    /**
     * The IsPayed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IsPayed;
    /**
     * The deliveryPriceRUR
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Money
     */
    public $deliveryPriceRUR;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $comment;
    /**
     * The MobilePhone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MobilePhone;
    /**
     * The timeDeliveryFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timeDeliveryFrom;
    /**
     * The timeDeliveryTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timeDeliveryTo;
    /**
     * The whoLastChange
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $whoLastChange;
    /**
     * The deliveryForMkadRUR
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Money
     */
    public $deliveryForMkadRUR;
    /**
     * The PAN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PAN;
    /**
     * The orderIDImport
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $orderIDImport;
    /**
     * The manager
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $manager;
    /**
     * The serviceDC
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Money
     */
    public $serviceDC;
    /**
     * The assessedCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Money
     */
    public $assessedCost;
    /**
     * The total
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Money
     */
    public $total;
    /**
     * The volume
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $volume;
    /**
     * Constructor method for ImpOrder
     * @uses ImpOrder::setOrderID()
     * @uses ImpOrder::setUserID()
     * @uses ImpOrder::setCompleteDate()
     * @uses ImpOrder::setDeliveryDate()
     * @uses ImpOrder::setIsRefusalWithDelivery()
     * @uses ImpOrder::setStatus()
     * @uses ImpOrder::setOrderRBSStateID()
     * @uses ImpOrder::setPaytype()
     * @uses ImpOrder::setModifyDate()
     * @uses ImpOrder::setSumByCard()
     * @uses ImpOrder::setTypeDelivery()
     * @uses ImpOrder::setServiceDelivery()
     * @uses ImpOrder::setPiecesOfFreight()
     * @uses ImpOrder::setUserAddressID()
     * @uses ImpOrder::setSettingID()
     * @uses ImpOrder::setSelfDelivery()
     * @uses ImpOrder::setIsPayed()
     * @uses ImpOrder::setDeliveryPriceRUR()
     * @uses ImpOrder::setComment()
     * @uses ImpOrder::setMobilePhone()
     * @uses ImpOrder::setTimeDeliveryFrom()
     * @uses ImpOrder::setTimeDeliveryTo()
     * @uses ImpOrder::setWhoLastChange()
     * @uses ImpOrder::setDeliveryForMkadRUR()
     * @uses ImpOrder::setPAN()
     * @uses ImpOrder::setOrderIDImport()
     * @uses ImpOrder::setManager()
     * @uses ImpOrder::setServiceDC()
     * @uses ImpOrder::setAssessedCost()
     * @uses ImpOrder::setTotal()
     * @uses ImpOrder::setVolume()
     * @param int $orderID
     * @param int $userID
     * @param string $completeDate
     * @param string $deliveryDate
     * @param bool $isRefusalWithDelivery
     * @param int $status
     * @param int $orderRBSStateID
     * @param int $paytype
     * @param string $modifyDate
     * @param int $sumByCard
     * @param int $typeDelivery
     * @param int $serviceDelivery
     * @param int $piecesOfFreight
     * @param int $userAddressID
     * @param int $settingID
     * @param int $selfDelivery
     * @param int $isPayed
     * @param \StructType\Money $deliveryPriceRUR
     * @param string $comment
     * @param string $mobilePhone
     * @param string $timeDeliveryFrom
     * @param string $timeDeliveryTo
     * @param string $whoLastChange
     * @param \StructType\Money $deliveryForMkadRUR
     * @param string $pAN
     * @param string $orderIDImport
     * @param string $manager
     * @param \StructType\Money $serviceDC
     * @param \StructType\Money $assessedCost
     * @param \StructType\Money $total
     * @param float $volume
     */
    public function __construct($orderID = null, $userID = null, $completeDate = null, $deliveryDate = null, $isRefusalWithDelivery = null, $status = null, $orderRBSStateID = null, $paytype = null, $modifyDate = null, $sumByCard = null, $typeDelivery = null, $serviceDelivery = null, $piecesOfFreight = null, $userAddressID = null, $settingID = null, $selfDelivery = null, $isPayed = null, \StructType\Money $deliveryPriceRUR = null, $comment = null, $mobilePhone = null, $timeDeliveryFrom = null, $timeDeliveryTo = null, $whoLastChange = null, \StructType\Money $deliveryForMkadRUR = null, $pAN = null, $orderIDImport = null, $manager = null, \StructType\Money $serviceDC = null, \StructType\Money $assessedCost = null, \StructType\Money $total = null, $volume = null)
    {
        $this
            ->setOrderID($orderID)
            ->setUserID($userID)
            ->setCompleteDate($completeDate)
            ->setDeliveryDate($deliveryDate)
            ->setIsRefusalWithDelivery($isRefusalWithDelivery)
            ->setStatus($status)
            ->setOrderRBSStateID($orderRBSStateID)
            ->setPaytype($paytype)
            ->setModifyDate($modifyDate)
            ->setSumByCard($sumByCard)
            ->setTypeDelivery($typeDelivery)
            ->setServiceDelivery($serviceDelivery)
            ->setPiecesOfFreight($piecesOfFreight)
            ->setUserAddressID($userAddressID)
            ->setSettingID($settingID)
            ->setSelfDelivery($selfDelivery)
            ->setIsPayed($isPayed)
            ->setDeliveryPriceRUR($deliveryPriceRUR)
            ->setComment($comment)
            ->setMobilePhone($mobilePhone)
            ->setTimeDeliveryFrom($timeDeliveryFrom)
            ->setTimeDeliveryTo($timeDeliveryTo)
            ->setWhoLastChange($whoLastChange)
            ->setDeliveryForMkadRUR($deliveryForMkadRUR)
            ->setPAN($pAN)
            ->setOrderIDImport($orderIDImport)
            ->setManager($manager)
            ->setServiceDC($serviceDC)
            ->setAssessedCost($assessedCost)
            ->setTotal($total)
            ->setVolume($volume);
    }
    /**
     * Get orderID value
     * @return int
     */
    public function getOrderID()
    {
        return $this->orderID;
    }
    /**
     * Set orderID value
     * @param int $orderID
     * @return \StructType\ImpOrder
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: int
        if (!is_null($orderID) && !(is_int($orderID) || ctype_digit($orderID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->orderID = $orderID;
        return $this;
    }
    /**
     * Get userID value
     * @return int
     */
    public function getUserID()
    {
        return $this->userID;
    }
    /**
     * Set userID value
     * @param int $userID
     * @return \StructType\ImpOrder
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !(is_int($userID) || ctype_digit($userID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        $this->userID = $userID;
        return $this;
    }
    /**
     * Get completeDate value
     * @return string
     */
    public function getCompleteDate()
    {
        return $this->completeDate;
    }
    /**
     * Set completeDate value
     * @param string $completeDate
     * @return \StructType\ImpOrder
     */
    public function setCompleteDate($completeDate = null)
    {
        // validation for constraint: string
        if (!is_null($completeDate) && !is_string($completeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($completeDate, true), gettype($completeDate)), __LINE__);
        }
        $this->completeDate = $completeDate;
        return $this;
    }
    /**
     * Get deliveryDate value
     * @return string
     */
    public function getDeliveryDate()
    {
        return $this->deliveryDate;
    }
    /**
     * Set deliveryDate value
     * @param string $deliveryDate
     * @return \StructType\ImpOrder
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        $this->deliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get IsRefusalWithDelivery value
     * @return bool
     */
    public function getIsRefusalWithDelivery()
    {
        return $this->IsRefusalWithDelivery;
    }
    /**
     * Set IsRefusalWithDelivery value
     * @param bool $isRefusalWithDelivery
     * @return \StructType\ImpOrder
     */
    public function setIsRefusalWithDelivery($isRefusalWithDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRefusalWithDelivery) && !is_bool($isRefusalWithDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRefusalWithDelivery, true), gettype($isRefusalWithDelivery)), __LINE__);
        }
        $this->IsRefusalWithDelivery = $isRefusalWithDelivery;
        return $this;
    }
    /**
     * Get status value
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \StructType\ImpOrder
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get orderRBSStateID value
     * @return int
     */
    public function getOrderRBSStateID()
    {
        return $this->orderRBSStateID;
    }
    /**
     * Set orderRBSStateID value
     * @param int $orderRBSStateID
     * @return \StructType\ImpOrder
     */
    public function setOrderRBSStateID($orderRBSStateID = null)
    {
        // validation for constraint: int
        if (!is_null($orderRBSStateID) && !(is_int($orderRBSStateID) || ctype_digit($orderRBSStateID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderRBSStateID, true), gettype($orderRBSStateID)), __LINE__);
        }
        $this->orderRBSStateID = $orderRBSStateID;
        return $this;
    }
    /**
     * Get paytype value
     * @return int
     */
    public function getPaytype()
    {
        return $this->paytype;
    }
    /**
     * Set paytype value
     * @param int $paytype
     * @return \StructType\ImpOrder
     */
    public function setPaytype($paytype = null)
    {
        // validation for constraint: int
        if (!is_null($paytype) && !(is_int($paytype) || ctype_digit($paytype))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paytype, true), gettype($paytype)), __LINE__);
        }
        $this->paytype = $paytype;
        return $this;
    }
    /**
     * Get modifyDate value
     * @return string
     */
    public function getModifyDate()
    {
        return $this->modifyDate;
    }
    /**
     * Set modifyDate value
     * @param string $modifyDate
     * @return \StructType\ImpOrder
     */
    public function setModifyDate($modifyDate = null)
    {
        // validation for constraint: string
        if (!is_null($modifyDate) && !is_string($modifyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modifyDate, true), gettype($modifyDate)), __LINE__);
        }
        $this->modifyDate = $modifyDate;
        return $this;
    }
    /**
     * Get SumByCard value
     * @return int
     */
    public function getSumByCard()
    {
        return $this->SumByCard;
    }
    /**
     * Set SumByCard value
     * @param int $sumByCard
     * @return \StructType\ImpOrder
     */
    public function setSumByCard($sumByCard = null)
    {
        // validation for constraint: int
        if (!is_null($sumByCard) && !(is_int($sumByCard) || ctype_digit($sumByCard))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sumByCard, true), gettype($sumByCard)), __LINE__);
        }
        $this->SumByCard = $sumByCard;
        return $this;
    }
    /**
     * Get typeDelivery value
     * @return int
     */
    public function getTypeDelivery()
    {
        return $this->typeDelivery;
    }
    /**
     * Set typeDelivery value
     * @param int $typeDelivery
     * @return \StructType\ImpOrder
     */
    public function setTypeDelivery($typeDelivery = null)
    {
        // validation for constraint: int
        if (!is_null($typeDelivery) && !(is_int($typeDelivery) || ctype_digit($typeDelivery))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($typeDelivery, true), gettype($typeDelivery)), __LINE__);
        }
        $this->typeDelivery = $typeDelivery;
        return $this;
    }
    /**
     * Get ServiceDelivery value
     * @return int
     */
    public function getServiceDelivery()
    {
        return $this->ServiceDelivery;
    }
    /**
     * Set ServiceDelivery value
     * @param int $serviceDelivery
     * @return \StructType\ImpOrder
     */
    public function setServiceDelivery($serviceDelivery = null)
    {
        // validation for constraint: int
        if (!is_null($serviceDelivery) && !(is_int($serviceDelivery) || ctype_digit($serviceDelivery))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serviceDelivery, true), gettype($serviceDelivery)), __LINE__);
        }
        $this->ServiceDelivery = $serviceDelivery;
        return $this;
    }
    /**
     * Get PiecesOfFreight value
     * @return int
     */
    public function getPiecesOfFreight()
    {
        return $this->PiecesOfFreight;
    }
    /**
     * Set PiecesOfFreight value
     * @param int $piecesOfFreight
     * @return \StructType\ImpOrder
     */
    public function setPiecesOfFreight($piecesOfFreight = null)
    {
        // validation for constraint: int
        if (!is_null($piecesOfFreight) && !(is_int($piecesOfFreight) || ctype_digit($piecesOfFreight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($piecesOfFreight, true), gettype($piecesOfFreight)), __LINE__);
        }
        $this->PiecesOfFreight = $piecesOfFreight;
        return $this;
    }
    /**
     * Get userAddressID value
     * @return int
     */
    public function getUserAddressID()
    {
        return $this->userAddressID;
    }
    /**
     * Set userAddressID value
     * @param int $userAddressID
     * @return \StructType\ImpOrder
     */
    public function setUserAddressID($userAddressID = null)
    {
        // validation for constraint: int
        if (!is_null($userAddressID) && !(is_int($userAddressID) || ctype_digit($userAddressID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userAddressID, true), gettype($userAddressID)), __LINE__);
        }
        $this->userAddressID = $userAddressID;
        return $this;
    }
    /**
     * Get SettingID value
     * @return int
     */
    public function getSettingID()
    {
        return $this->SettingID;
    }
    /**
     * Set SettingID value
     * @param int $settingID
     * @return \StructType\ImpOrder
     */
    public function setSettingID($settingID = null)
    {
        // validation for constraint: int
        if (!is_null($settingID) && !(is_int($settingID) || ctype_digit($settingID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($settingID, true), gettype($settingID)), __LINE__);
        }
        $this->SettingID = $settingID;
        return $this;
    }
    /**
     * Get selfDelivery value
     * @return int
     */
    public function getSelfDelivery()
    {
        return $this->selfDelivery;
    }
    /**
     * Set selfDelivery value
     * @param int $selfDelivery
     * @return \StructType\ImpOrder
     */
    public function setSelfDelivery($selfDelivery = null)
    {
        // validation for constraint: int
        if (!is_null($selfDelivery) && !(is_int($selfDelivery) || ctype_digit($selfDelivery))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($selfDelivery, true), gettype($selfDelivery)), __LINE__);
        }
        $this->selfDelivery = $selfDelivery;
        return $this;
    }
    /**
     * Get IsPayed value
     * @return int
     */
    public function getIsPayed()
    {
        return $this->IsPayed;
    }
    /**
     * Set IsPayed value
     * @param int $isPayed
     * @return \StructType\ImpOrder
     */
    public function setIsPayed($isPayed = null)
    {
        // validation for constraint: int
        if (!is_null($isPayed) && !(is_int($isPayed) || ctype_digit($isPayed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($isPayed, true), gettype($isPayed)), __LINE__);
        }
        $this->IsPayed = $isPayed;
        return $this;
    }
    /**
     * Get deliveryPriceRUR value
     * @return \StructType\Money|null
     */
    public function getDeliveryPriceRUR()
    {
        return $this->deliveryPriceRUR;
    }
    /**
     * Set deliveryPriceRUR value
     * @param \StructType\Money $deliveryPriceRUR
     * @return \StructType\ImpOrder
     */
    public function setDeliveryPriceRUR(\StructType\Money $deliveryPriceRUR = null)
    {
        $this->deliveryPriceRUR = $deliveryPriceRUR;
        return $this;
    }
    /**
     * Get comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set comment value
     * @param string $comment
     * @return \StructType\ImpOrder
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get MobilePhone value
     * @return string|null
     */
    public function getMobilePhone()
    {
        return $this->MobilePhone;
    }
    /**
     * Set MobilePhone value
     * @param string $mobilePhone
     * @return \StructType\ImpOrder
     */
    public function setMobilePhone($mobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePhone) && !is_string($mobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobilePhone, true), gettype($mobilePhone)), __LINE__);
        }
        $this->MobilePhone = $mobilePhone;
        return $this;
    }
    /**
     * Get timeDeliveryFrom value
     * @return string|null
     */
    public function getTimeDeliveryFrom()
    {
        return $this->timeDeliveryFrom;
    }
    /**
     * Set timeDeliveryFrom value
     * @param string $timeDeliveryFrom
     * @return \StructType\ImpOrder
     */
    public function setTimeDeliveryFrom($timeDeliveryFrom = null)
    {
        // validation for constraint: string
        if (!is_null($timeDeliveryFrom) && !is_string($timeDeliveryFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeDeliveryFrom, true), gettype($timeDeliveryFrom)), __LINE__);
        }
        $this->timeDeliveryFrom = $timeDeliveryFrom;
        return $this;
    }
    /**
     * Get timeDeliveryTo value
     * @return string|null
     */
    public function getTimeDeliveryTo()
    {
        return $this->timeDeliveryTo;
    }
    /**
     * Set timeDeliveryTo value
     * @param string $timeDeliveryTo
     * @return \StructType\ImpOrder
     */
    public function setTimeDeliveryTo($timeDeliveryTo = null)
    {
        // validation for constraint: string
        if (!is_null($timeDeliveryTo) && !is_string($timeDeliveryTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeDeliveryTo, true), gettype($timeDeliveryTo)), __LINE__);
        }
        $this->timeDeliveryTo = $timeDeliveryTo;
        return $this;
    }
    /**
     * Get whoLastChange value
     * @return string|null
     */
    public function getWhoLastChange()
    {
        return $this->whoLastChange;
    }
    /**
     * Set whoLastChange value
     * @param string $whoLastChange
     * @return \StructType\ImpOrder
     */
    public function setWhoLastChange($whoLastChange = null)
    {
        // validation for constraint: string
        if (!is_null($whoLastChange) && !is_string($whoLastChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($whoLastChange, true), gettype($whoLastChange)), __LINE__);
        }
        $this->whoLastChange = $whoLastChange;
        return $this;
    }
    /**
     * Get deliveryForMkadRUR value
     * @return \StructType\Money|null
     */
    public function getDeliveryForMkadRUR()
    {
        return $this->deliveryForMkadRUR;
    }
    /**
     * Set deliveryForMkadRUR value
     * @param \StructType\Money $deliveryForMkadRUR
     * @return \StructType\ImpOrder
     */
    public function setDeliveryForMkadRUR(\StructType\Money $deliveryForMkadRUR = null)
    {
        $this->deliveryForMkadRUR = $deliveryForMkadRUR;
        return $this;
    }
    /**
     * Get PAN value
     * @return string|null
     */
    public function getPAN()
    {
        return $this->PAN;
    }
    /**
     * Set PAN value
     * @param string $pAN
     * @return \StructType\ImpOrder
     */
    public function setPAN($pAN = null)
    {
        // validation for constraint: string
        if (!is_null($pAN) && !is_string($pAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pAN, true), gettype($pAN)), __LINE__);
        }
        $this->PAN = $pAN;
        return $this;
    }
    /**
     * Get orderIDImport value
     * @return string|null
     */
    public function getOrderIDImport()
    {
        return $this->orderIDImport;
    }
    /**
     * Set orderIDImport value
     * @param string $orderIDImport
     * @return \StructType\ImpOrder
     */
    public function setOrderIDImport($orderIDImport = null)
    {
        // validation for constraint: string
        if (!is_null($orderIDImport) && !is_string($orderIDImport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderIDImport, true), gettype($orderIDImport)), __LINE__);
        }
        $this->orderIDImport = $orderIDImport;
        return $this;
    }
    /**
     * Get manager value
     * @return string|null
     */
    public function getManager()
    {
        return $this->manager;
    }
    /**
     * Set manager value
     * @param string $manager
     * @return \StructType\ImpOrder
     */
    public function setManager($manager = null)
    {
        // validation for constraint: string
        if (!is_null($manager) && !is_string($manager)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manager, true), gettype($manager)), __LINE__);
        }
        $this->manager = $manager;
        return $this;
    }
    /**
     * Get serviceDC value
     * @return \StructType\Money|null
     */
    public function getServiceDC()
    {
        return $this->serviceDC;
    }
    /**
     * Set serviceDC value
     * @param \StructType\Money $serviceDC
     * @return \StructType\ImpOrder
     */
    public function setServiceDC(\StructType\Money $serviceDC = null)
    {
        $this->serviceDC = $serviceDC;
        return $this;
    }
    /**
     * Get assessedCost value
     * @return \StructType\Money|null
     */
    public function getAssessedCost()
    {
        return $this->assessedCost;
    }
    /**
     * Set assessedCost value
     * @param \StructType\Money $assessedCost
     * @return \StructType\ImpOrder
     */
    public function setAssessedCost(\StructType\Money $assessedCost = null)
    {
        $this->assessedCost = $assessedCost;
        return $this;
    }
    /**
     * Get total value
     * @return \StructType\Money|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param \StructType\Money $total
     * @return \StructType\ImpOrder
     */
    public function setTotal(\StructType\Money $total = null)
    {
        $this->total = $total;
        return $this;
    }
    /**
     * Get volume value
     * @return float|null
     */
    public function getVolume()
    {
        return $this->volume;
    }
    /**
     * Set volume value
     * @param float $volume
     * @return \StructType\ImpOrder
     */
    public function setVolume($volume = null)
    {
        // validation for constraint: float
        if (!is_null($volume) && !(is_float($volume) || is_numeric($volume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($volume, true), gettype($volume)), __LINE__);
        }
        $this->volume = $volume;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ImpOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
