<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Terminals StructType
 * @subpackage Structs
 */
class Terminals extends AbstractStructBase
{
    /**
     * The Terminal
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Terminal[]
     */
    public $Terminal;
    /**
     * Constructor method for Terminals
     * @uses Terminals::setTerminal()
     * @param \StructType\Terminal[] $terminal
     */
    public function __construct(array $terminal = array())
    {
        $this
            ->setTerminal($terminal);
    }
    /**
     * Get Terminal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Terminal[]|null
     */
    public function getTerminal()
    {
        return isset($this->Terminal) ? $this->Terminal : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTerminal method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTerminal method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTerminalForArrayConstraintsFromSetTerminal(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $terminalsTerminalItem) {
            // validation for constraint: itemType
            if (!$terminalsTerminalItem instanceof \StructType\Terminal) {
                $invalidValues[] = is_object($terminalsTerminalItem) ? get_class($terminalsTerminalItem) : sprintf('%s(%s)', gettype($terminalsTerminalItem), var_export($terminalsTerminalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Terminal property can only contain items of type \StructType\Terminal, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Terminal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Terminal[] $terminal
     * @return \StructType\Terminals
     */
    public function setTerminal(array $terminal = array())
    {
        // validation for constraint: array
        if ('' !== ($terminalArrayErrorMessage = self::validateTerminalForArrayConstraintsFromSetTerminal($terminal))) {
            throw new \InvalidArgumentException($terminalArrayErrorMessage, __LINE__);
        }
        if (is_null($terminal) || (is_array($terminal) && empty($terminal))) {
            unset($this->Terminal);
        } else {
            $this->Terminal = $terminal;
        }
        return $this;
    }
    /**
     * Add item to Terminal value
     * @throws \InvalidArgumentException
     * @param \StructType\Terminal $item
     * @return \StructType\Terminals
     */
    public function addToTerminal(\StructType\Terminal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Terminal) {
            throw new \InvalidArgumentException(sprintf('The Terminal property can only contain items of type \StructType\Terminal, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Terminal[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Terminals
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
