<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderChanged StructType
 * @subpackage Structs
 */
class OrderChanged extends AbstractStructBase
{
    /**
     * The orderID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $orderID;
    /**
     * The ReasonRrefusal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReasonRrefusal;
    /**
     * Constructor method for OrderChanged
     * @uses OrderChanged::setOrderID()
     * @uses OrderChanged::setReasonRrefusal()
     * @param int $orderID
     * @param string $reasonRrefusal
     */
    public function __construct($orderID = null, $reasonRrefusal = null)
    {
        $this
            ->setOrderID($orderID)
            ->setReasonRrefusal($reasonRrefusal);
    }
    /**
     * Get orderID value
     * @return int
     */
    public function getOrderID()
    {
        return $this->orderID;
    }
    /**
     * Set orderID value
     * @param int $orderID
     * @return \StructType\OrderChanged
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: int
        if (!is_null($orderID) && !(is_int($orderID) || ctype_digit($orderID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderID, true), gettype($orderID)), __LINE__);
        }
        $this->orderID = $orderID;
        return $this;
    }
    /**
     * Get ReasonRrefusal value
     * @return string|null
     */
    public function getReasonRrefusal()
    {
        return $this->ReasonRrefusal;
    }
    /**
     * Set ReasonRrefusal value
     * @param string $reasonRrefusal
     * @return \StructType\OrderChanged
     */
    public function setReasonRrefusal($reasonRrefusal = null)
    {
        // validation for constraint: string
        if (!is_null($reasonRrefusal) && !is_string($reasonRrefusal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonRrefusal, true), gettype($reasonRrefusal)), __LINE__);
        }
        $this->ReasonRrefusal = $reasonRrefusal;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderChanged
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
