<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address StructType
 * @subpackage Structs
 */
class Address extends AbstractStructBase
{
    /**
     * The Region
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Region;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The Street
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Street;
    /**
     * The House
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $House;
    /**
     * The Case
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Case;
    /**
     * The Building
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Building;
    /**
     * The Apartment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Apartment;
    /**
     * The ZipCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZipCode;
    /**
     * The FullAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FullAddress;
    /**
     * The AddressComment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressComment;
    /**
     * Constructor method for Address
     * @uses Address::setRegion()
     * @uses Address::setCity()
     * @uses Address::setStreet()
     * @uses Address::setHouse()
     * @uses Address::setCase()
     * @uses Address::setBuilding()
     * @uses Address::setApartment()
     * @uses Address::setZipCode()
     * @uses Address::setFullAddress()
     * @uses Address::setAddressComment()
     * @param string $region
     * @param string $city
     * @param string $street
     * @param string $house
     * @param string $case
     * @param string $building
     * @param string $apartment
     * @param string $zipCode
     * @param string $fullAddress
     * @param string $addressComment
     */
    public function __construct($region = null, $city = null, $street = null, $house = null, $case = null, $building = null, $apartment = null, $zipCode = null, $fullAddress = null, $addressComment = null)
    {
        $this
            ->setRegion($region)
            ->setCity($city)
            ->setStreet($street)
            ->setHouse($house)
            ->setCase($case)
            ->setBuilding($building)
            ->setApartment($apartment)
            ->setZipCode($zipCode)
            ->setFullAddress($fullAddress)
            ->setAddressComment($addressComment);
    }
    /**
     * Get Region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->Region;
    }
    /**
     * Set Region value
     * @param string $region
     * @return \StructType\Address
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($region, true), gettype($region)), __LINE__);
        }
        $this->Region = $region;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\Address
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get Street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->Street;
    }
    /**
     * Set Street value
     * @param string $street
     * @return \StructType\Address
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        $this->Street = $street;
        return $this;
    }
    /**
     * Get House value
     * @return string|null
     */
    public function getHouse()
    {
        return $this->House;
    }
    /**
     * Set House value
     * @param string $house
     * @return \StructType\Address
     */
    public function setHouse($house = null)
    {
        // validation for constraint: string
        if (!is_null($house) && !is_string($house)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($house, true), gettype($house)), __LINE__);
        }
        $this->House = $house;
        return $this;
    }
    /**
     * Get Case value
     * @return string|null
     */
    public function getCase()
    {
        return $this->Case;
    }
    /**
     * Set Case value
     * @param string $case
     * @return \StructType\Address
     */
    public function setCase($case = null)
    {
        // validation for constraint: string
        if (!is_null($case) && !is_string($case)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($case, true), gettype($case)), __LINE__);
        }
        $this->Case = $case;
        return $this;
    }
    /**
     * Get Building value
     * @return string|null
     */
    public function getBuilding()
    {
        return $this->Building;
    }
    /**
     * Set Building value
     * @param string $building
     * @return \StructType\Address
     */
    public function setBuilding($building = null)
    {
        // validation for constraint: string
        if (!is_null($building) && !is_string($building)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($building, true), gettype($building)), __LINE__);
        }
        $this->Building = $building;
        return $this;
    }
    /**
     * Get Apartment value
     * @return string|null
     */
    public function getApartment()
    {
        return $this->Apartment;
    }
    /**
     * Set Apartment value
     * @param string $apartment
     * @return \StructType\Address
     */
    public function setApartment($apartment = null)
    {
        // validation for constraint: string
        if (!is_null($apartment) && !is_string($apartment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apartment, true), gettype($apartment)), __LINE__);
        }
        $this->Apartment = $apartment;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \StructType\Address
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }
    /**
     * Get FullAddress value
     * @return string|null
     */
    public function getFullAddress()
    {
        return $this->FullAddress;
    }
    /**
     * Set FullAddress value
     * @param string $fullAddress
     * @return \StructType\Address
     */
    public function setFullAddress($fullAddress = null)
    {
        // validation for constraint: string
        if (!is_null($fullAddress) && !is_string($fullAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullAddress, true), gettype($fullAddress)), __LINE__);
        }
        $this->FullAddress = $fullAddress;
        return $this;
    }
    /**
     * Get AddressComment value
     * @return string|null
     */
    public function getAddressComment()
    {
        return $this->AddressComment;
    }
    /**
     * Set AddressComment value
     * @param string $addressComment
     * @return \StructType\Address
     */
    public function setAddressComment($addressComment = null)
    {
        // validation for constraint: string
        if (!is_null($addressComment) && !is_string($addressComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressComment, true), gettype($addressComment)), __LINE__);
        }
        $this->AddressComment = $addressComment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Address
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
