<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SetOrderParams
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetOrderParams $parameters
     * @return \StructType\SetOrderParamsResponse|bool
     */
    public function SetOrderParams(\StructType\SetOrderParams $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetOrderParams($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetOrderBarcodes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetOrderBarcodes $parameters
     * @return \StructType\SetOrderBarcodesResponse|bool
     */
    public function SetOrderBarcodes(\StructType\SetOrderBarcodes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetOrderBarcodes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetOrderIDAdditional
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetOrderIDAdditional $parameters
     * @return \StructType\SetOrderIDAdditionalResponse|bool
     */
    public function SetOrderIDAdditional(\StructType\SetOrderIDAdditional $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetOrderIDAdditional($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetTerminalsForIntake
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetTerminalsForIntake $parameters
     * @return \StructType\SetTerminalsForIntakeResponse|bool
     */
    public function SetTerminalsForIntake(\StructType\SetTerminalsForIntake $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetTerminalsForIntake($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetOrdersStatusExternalRoute
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetOrdersStatusExternalRoute $parameters
     * @return \StructType\SetOrdersStatusExternalRouteResponse|bool
     */
    public function SetOrdersStatusExternalRoute(\StructType\SetOrdersStatusExternalRoute $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetOrdersStatusExternalRoute($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetCrewForExternalRoute
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetCrewForExternalRoute $parameters
     * @return \StructType\SetCrewForExternalRouteResponse|bool
     */
    public function SetCrewForExternalRoute(\StructType\SetCrewForExternalRoute $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetCrewForExternalRoute($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetOrderDocuments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetOrderDocuments $parameters
     * @return \StructType\SetOrderDocumentsResponse|bool
     */
    public function SetOrderDocuments(\StructType\SetOrderDocuments $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetOrderDocuments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SetCrewForExternalRouteResponse|\StructType\SetOrderBarcodesResponse|\StructType\SetOrderDocumentsResponse|\StructType\SetOrderIDAdditionalResponse|\StructType\SetOrderParamsResponse|\StructType\SetOrdersStatusExternalRouteResponse|\StructType\SetTerminalsForIntakeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
