<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RefusedOrderItem StructType
 * @subpackage Structs
 */
class RefusedOrderItem extends AbstractStructBase
{
    /**
     * The count
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $count;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $price;
    /**
     * The code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $code;
    /**
     * The barcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $barcode;
    /**
     * The markingCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $markingCode;
    /**
     * Constructor method for RefusedOrderItem
     * @uses RefusedOrderItem::setCount()
     * @uses RefusedOrderItem::setPrice()
     * @uses RefusedOrderItem::setCode()
     * @uses RefusedOrderItem::setBarcode()
     * @uses RefusedOrderItem::setMarkingCode()
     * @param int $count
     * @param int $price
     * @param string $code
     * @param string $barcode
     * @param string $markingCode
     */
    public function __construct($count = null, $price = null, $code = null, $barcode = null, $markingCode = null)
    {
        $this
            ->setCount($count)
            ->setPrice($price)
            ->setCode($code)
            ->setBarcode($barcode)
            ->setMarkingCode($markingCode);
    }
    /**
     * Get count value
     * @return int
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param int $count
     * @return \StructType\RefusedOrderItem
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Get price value
     * @return int
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param int $price
     * @return \StructType\RefusedOrderItem
     */
    public function setPrice($price = null)
    {
        // validation for constraint: int
        if (!is_null($price) && !(is_int($price) || ctype_digit($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\RefusedOrderItem
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->barcode;
    }
    /**
     * Set barcode value
     * @param string $barcode
     * @return \StructType\RefusedOrderItem
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        $this->barcode = $barcode;
        return $this;
    }
    /**
     * Get markingCode value
     * @return string|null
     */
    public function getMarkingCode()
    {
        return $this->markingCode;
    }
    /**
     * Set markingCode value
     * @param string $markingCode
     * @return \StructType\RefusedOrderItem
     */
    public function setMarkingCode($markingCode = null)
    {
        // validation for constraint: string
        if (!is_null($markingCode) && !is_string($markingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($markingCode, true), gettype($markingCode)), __LINE__);
        }
        $this->markingCode = $markingCode;
        return $this;
    }
}
