<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item StructType
 * @subpackage Structs
 */
class Item extends AbstractStructBase
{
    /**
     * The Count
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Count;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Price;
    /**
     * The NDS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NDS;
    /**
     * The Article
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Article;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The AssessedCost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AssessedCost;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Barcode;
    /**
     * The BarcodePackage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BarcodePackage;
    /**
     * The MarkingCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MarkingCode;
    /**
     * The SellerInn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SellerInn;
    /**
     * The SellerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SellerName;
    /**
     * The SellerPhone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SellerPhone;
    /**
     * The MarkingCodeBase64
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MarkingCodeBase64;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemType;
    /**
     * Constructor method for Item
     * @uses Item::setCount()
     * @uses Item::setPrice()
     * @uses Item::setNDS()
     * @uses Item::setArticle()
     * @uses Item::setName()
     * @uses Item::setAssessedCost()
     * @uses Item::setBarcode()
     * @uses Item::setBarcodePackage()
     * @uses Item::setMarkingCode()
     * @uses Item::setSellerInn()
     * @uses Item::setSellerName()
     * @uses Item::setSellerPhone()
     * @uses Item::setMarkingCodeBase64()
     * @uses Item::setItemType()
     * @param int $count
     * @param float $price
     * @param int $nDS
     * @param string $article
     * @param string $name
     * @param float $assessedCost
     * @param string $barcode
     * @param string $barcodePackage
     * @param string $markingCode
     * @param string $sellerInn
     * @param string $sellerName
     * @param string $sellerPhone
     * @param string $markingCodeBase64
     * @param string $itemType
     */
    public function __construct($count = null, $price = null, $nDS = null, $article = null, $name = null, $assessedCost = null, $barcode = null, $barcodePackage = null, $markingCode = null, $sellerInn = null, $sellerName = null, $sellerPhone = null, $markingCodeBase64 = null, $itemType = null)
    {
        $this
            ->setCount($count)
            ->setPrice($price)
            ->setNDS($nDS)
            ->setArticle($article)
            ->setName($name)
            ->setAssessedCost($assessedCost)
            ->setBarcode($barcode)
            ->setBarcodePackage($barcodePackage)
            ->setMarkingCode($markingCode)
            ->setSellerInn($sellerInn)
            ->setSellerName($sellerName)
            ->setSellerPhone($sellerPhone)
            ->setMarkingCodeBase64($markingCodeBase64)
            ->setItemType($itemType);
    }
    /**
     * Get Count value
     * @return int
     */
    public function getCount()
    {
        return $this->Count;
    }
    /**
     * Set Count value
     * @param int $count
     * @return \StructType\Item
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->Count = $count;
        return $this;
    }
    /**
     * Get Price value
     * @return float
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\Item
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get NDS value
     * @return int
     */
    public function getNDS()
    {
        return $this->NDS;
    }
    /**
     * Set NDS value
     * @param int $nDS
     * @return \StructType\Item
     */
    public function setNDS($nDS = null)
    {
        // validation for constraint: int
        if (!is_null($nDS) && !(is_int($nDS) || ctype_digit($nDS))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nDS, true), gettype($nDS)), __LINE__);
        }
        $this->NDS = $nDS;
        return $this;
    }
    /**
     * Get Article value
     * @return string|null
     */
    public function getArticle()
    {
        return $this->Article;
    }
    /**
     * Set Article value
     * @param string $article
     * @return \StructType\Item
     */
    public function setArticle($article = null)
    {
        // validation for constraint: string
        if (!is_null($article) && !is_string($article)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($article, true), gettype($article)), __LINE__);
        }
        $this->Article = $article;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Item
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get AssessedCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAssessedCost()
    {
        return isset($this->AssessedCost) ? $this->AssessedCost : null;
    }
    /**
     * Set AssessedCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $assessedCost
     * @return \StructType\Item
     */
    public function setAssessedCost($assessedCost = null)
    {
        // validation for constraint: float
        if (!is_null($assessedCost) && !(is_float($assessedCost) || is_numeric($assessedCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($assessedCost, true), gettype($assessedCost)), __LINE__);
        }
        if (is_null($assessedCost) || (is_array($assessedCost) && empty($assessedCost))) {
            unset($this->AssessedCost);
        } else {
            $this->AssessedCost = $assessedCost;
        }
        return $this;
    }
    /**
     * Get Barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }
    /**
     * Set Barcode value
     * @param string $barcode
     * @return \StructType\Item
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        $this->Barcode = $barcode;
        return $this;
    }
    /**
     * Get BarcodePackage value
     * @return string|null
     */
    public function getBarcodePackage()
    {
        return $this->BarcodePackage;
    }
    /**
     * Set BarcodePackage value
     * @param string $barcodePackage
     * @return \StructType\Item
     */
    public function setBarcodePackage($barcodePackage = null)
    {
        // validation for constraint: string
        if (!is_null($barcodePackage) && !is_string($barcodePackage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodePackage, true), gettype($barcodePackage)), __LINE__);
        }
        $this->BarcodePackage = $barcodePackage;
        return $this;
    }
    /**
     * Get MarkingCode value
     * @return string|null
     */
    public function getMarkingCode()
    {
        return $this->MarkingCode;
    }
    /**
     * Set MarkingCode value
     * @param string $markingCode
     * @return \StructType\Item
     */
    public function setMarkingCode($markingCode = null)
    {
        // validation for constraint: string
        if (!is_null($markingCode) && !is_string($markingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($markingCode, true), gettype($markingCode)), __LINE__);
        }
        $this->MarkingCode = $markingCode;
        return $this;
    }
    /**
     * Get SellerInn value
     * @return string|null
     */
    public function getSellerInn()
    {
        return $this->SellerInn;
    }
    /**
     * Set SellerInn value
     * @param string $sellerInn
     * @return \StructType\Item
     */
    public function setSellerInn($sellerInn = null)
    {
        // validation for constraint: string
        if (!is_null($sellerInn) && !is_string($sellerInn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerInn, true), gettype($sellerInn)), __LINE__);
        }
        $this->SellerInn = $sellerInn;
        return $this;
    }
    /**
     * Get SellerName value
     * @return string|null
     */
    public function getSellerName()
    {
        return $this->SellerName;
    }
    /**
     * Set SellerName value
     * @param string $sellerName
     * @return \StructType\Item
     */
    public function setSellerName($sellerName = null)
    {
        // validation for constraint: string
        if (!is_null($sellerName) && !is_string($sellerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerName, true), gettype($sellerName)), __LINE__);
        }
        $this->SellerName = $sellerName;
        return $this;
    }
    /**
     * Get SellerPhone value
     * @return string|null
     */
    public function getSellerPhone()
    {
        return $this->SellerPhone;
    }
    /**
     * Set SellerPhone value
     * @param string $sellerPhone
     * @return \StructType\Item
     */
    public function setSellerPhone($sellerPhone = null)
    {
        // validation for constraint: string
        if (!is_null($sellerPhone) && !is_string($sellerPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerPhone, true), gettype($sellerPhone)), __LINE__);
        }
        $this->SellerPhone = $sellerPhone;
        return $this;
    }
    /**
     * Get MarkingCodeBase64 value
     * @return string|null
     */
    public function getMarkingCodeBase64()
    {
        return $this->MarkingCodeBase64;
    }
    /**
     * Set MarkingCodeBase64 value
     * @param string $markingCodeBase64
     * @return \StructType\Item
     */
    public function setMarkingCodeBase64($markingCodeBase64 = null)
    {
        // validation for constraint: string
        if (!is_null($markingCodeBase64) && !is_string($markingCodeBase64)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($markingCodeBase64, true), gettype($markingCodeBase64)), __LINE__);
        }
        $this->MarkingCodeBase64 = $markingCodeBase64;
        return $this;
    }
    /**
     * Get ItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemType()
    {
        return isset($this->ItemType) ? $this->ItemType : null;
    }
    /**
     * Set ItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemType
     * @return \StructType\Item
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: string
        if (!is_null($itemType) && !is_string($itemType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemType, true), gettype($itemType)), __LINE__);
        }
        if (is_null($itemType) || (is_array($itemType) && empty($itemType))) {
            unset($this->ItemType);
        } else {
            $this->ItemType = $itemType;
        }
        return $this;
    }
}
