<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfShop ArrayType
 * @subpackage Arrays
 */
class ArrayOfShop extends AbstractStructArrayBase
{
    /**
     * The Shop
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Shop[]
     */
    public $Shop;
    /**
     * Constructor method for ArrayOfShop
     * @uses ArrayOfShop::setShop()
     * @param \StructType\Shop[] $shop
     */
    public function __construct(array $shop = array())
    {
        $this
            ->setShop($shop);
    }
    /**
     * Get Shop value
     * @return \StructType\Shop[]|null
     */
    public function getShop()
    {
        return $this->Shop;
    }
    /**
     * This method is responsible for validating the values passed to the setShop method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShop method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShopForArrayConstraintsFromSetShop(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfShopShopItem) {
            // validation for constraint: itemType
            if (!$arrayOfShopShopItem instanceof \StructType\Shop) {
                $invalidValues[] = is_object($arrayOfShopShopItem) ? get_class($arrayOfShopShopItem) : sprintf('%s(%s)', gettype($arrayOfShopShopItem), var_export($arrayOfShopShopItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Shop property can only contain items of type \StructType\Shop, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Shop value
     * @throws \InvalidArgumentException
     * @param \StructType\Shop[] $shop
     * @return \ArrayType\ArrayOfShop
     */
    public function setShop(array $shop = array())
    {
        // validation for constraint: array
        if ('' !== ($shopArrayErrorMessage = self::validateShopForArrayConstraintsFromSetShop($shop))) {
            throw new \InvalidArgumentException($shopArrayErrorMessage, __LINE__);
        }
        $this->Shop = $shop;
        return $this;
    }
    /**
     * Add item to Shop value
     * @throws \InvalidArgumentException
     * @param \StructType\Shop $item
     * @return \ArrayType\ArrayOfShop
     */
    public function addToShop(\StructType\Shop $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Shop) {
            throw new \InvalidArgumentException(sprintf('The Shop property can only contain items of type \StructType\Shop, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Shop[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Shop|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Shop|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Shop|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Shop|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Shop|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Shop
     */
    public function getAttributeName()
    {
        return 'Shop';
    }
}
