<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOrderGroup ArrayType
 * @subpackage Arrays
 */
class ArrayOfOrderGroup extends AbstractStructArrayBase
{
    /**
     * The OrderGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OrderGroup[]
     */
    public $OrderGroup;
    /**
     * Constructor method for ArrayOfOrderGroup
     * @uses ArrayOfOrderGroup::setOrderGroup()
     * @param \StructType\OrderGroup[] $orderGroup
     */
    public function __construct(array $orderGroup = array())
    {
        $this
            ->setOrderGroup($orderGroup);
    }
    /**
     * Get OrderGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OrderGroup[]|null
     */
    public function getOrderGroup()
    {
        return isset($this->OrderGroup) ? $this->OrderGroup : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderGroupForArrayConstraintsFromSetOrderGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfOrderGroupOrderGroupItem) {
            // validation for constraint: itemType
            if (!$arrayOfOrderGroupOrderGroupItem instanceof \StructType\OrderGroup) {
                $invalidValues[] = is_object($arrayOfOrderGroupOrderGroupItem) ? get_class($arrayOfOrderGroupOrderGroupItem) : sprintf('%s(%s)', gettype($arrayOfOrderGroupOrderGroupItem), var_export($arrayOfOrderGroupOrderGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderGroup property can only contain items of type \StructType\OrderGroup, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OrderGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OrderGroup[] $orderGroup
     * @return \ArrayType\ArrayOfOrderGroup
     */
    public function setOrderGroup(array $orderGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($orderGroupArrayErrorMessage = self::validateOrderGroupForArrayConstraintsFromSetOrderGroup($orderGroup))) {
            throw new \InvalidArgumentException($orderGroupArrayErrorMessage, __LINE__);
        }
        if (is_null($orderGroup) || (is_array($orderGroup) && empty($orderGroup))) {
            unset($this->OrderGroup);
        } else {
            $this->OrderGroup = $orderGroup;
        }
        return $this;
    }
    /**
     * Add item to OrderGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderGroup $item
     * @return \ArrayType\ArrayOfOrderGroup
     */
    public function addToOrderGroup(\StructType\OrderGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderGroup) {
            throw new \InvalidArgumentException(sprintf('The OrderGroup property can only contain items of type \StructType\OrderGroup, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderGroup[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\OrderGroup|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\OrderGroup|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\OrderGroup|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\OrderGroup|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\OrderGroup|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OrderGroup
     */
    public function getAttributeName()
    {
        return 'OrderGroup';
    }
}
