<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegisterWarehouse StructType
 * @subpackage Structs
 */
class RegisterWarehouse extends AbstractStructBase
{
    /**
     * The warehouse
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: s1:warehouse
     * @var \StructType\Warehouse
     */
    public $warehouse;
    /**
     * The settingId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $settingId;
    /**
     * The accessKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accessKey;
    /**
     * Constructor method for RegisterWarehouse
     * @uses RegisterWarehouse::setWarehouse()
     * @uses RegisterWarehouse::setSettingId()
     * @uses RegisterWarehouse::setAccessKey()
     * @param \StructType\Warehouse $warehouse
     * @param int $settingId
     * @param string $accessKey
     */
    public function __construct(\StructType\Warehouse $warehouse = null, $settingId = null, $accessKey = null)
    {
        $this
            ->setWarehouse($warehouse)
            ->setSettingId($settingId)
            ->setAccessKey($accessKey);
    }
    /**
     * Get warehouse value
     * @return \StructType\Warehouse
     */
    public function getWarehouse()
    {
        return $this->warehouse;
    }
    /**
     * Set warehouse value
     * @param \StructType\Warehouse $warehouse
     * @return \StructType\RegisterWarehouse
     */
    public function setWarehouse(\StructType\Warehouse $warehouse = null)
    {
        $this->warehouse = $warehouse;
        return $this;
    }
    /**
     * Get settingId value
     * @return int
     */
    public function getSettingId()
    {
        return $this->settingId;
    }
    /**
     * Set settingId value
     * @param int $settingId
     * @return \StructType\RegisterWarehouse
     */
    public function setSettingId($settingId = null)
    {
        // validation for constraint: int
        if (!is_null($settingId) && !(is_int($settingId) || ctype_digit($settingId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($settingId, true), gettype($settingId)), __LINE__);
        }
        $this->settingId = $settingId;
        return $this;
    }
    /**
     * Get accessKey value
     * @return string|null
     */
    public function getAccessKey()
    {
        return $this->accessKey;
    }
    /**
     * Set accessKey value
     * @param string $accessKey
     * @return \StructType\RegisterWarehouse
     */
    public function setAccessKey($accessKey = null)
    {
        // validation for constraint: string
        if (!is_null($accessKey) && !is_string($accessKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessKey, true), gettype($accessKey)), __LINE__);
        }
        $this->accessKey = $accessKey;
        return $this;
    }
}
