<?php

namespace Bitsaf\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bitsadtoSessionWrapper StructType
 * @package Bitsaf
 * @subpackage Structs
 */
class BitsafBitsadtoSessionWrapper extends AbstractStructBase
{
    /**
     * The result
     * @var int
     */
    public $result;
    /**
     * The resultMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $resultMessage;
    /**
     * The sessionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sessionId;
    /**
     * Constructor method for bitsadtoSessionWrapper
     * @uses BitsafBitsadtoSessionWrapper::setResult()
     * @uses BitsafBitsadtoSessionWrapper::setResultMessage()
     * @uses BitsafBitsadtoSessionWrapper::setSessionId()
     * @param int $result
     * @param string $resultMessage
     * @param string $sessionId
     */
    public function __construct($result = null, $resultMessage = null, $sessionId = null)
    {
        $this
            ->setResult($result)
            ->setResultMessage($resultMessage)
            ->setSessionId($sessionId);
    }
    /**
     * Get result value
     * @return int|null
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * Set result value
     * @param int $result
     * @return \Bitsaf\StructType\BitsafBitsadtoSessionWrapper
     */
    public function setResult($result = null)
    {
        // validation for constraint: int
        if (!is_null($result) && !(is_int($result) || ctype_digit($result))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        $this->result = $result;
        return $this;
    }
    /**
     * Get resultMessage value
     * @return string|null
     */
    public function getResultMessage()
    {
        return $this->resultMessage;
    }
    /**
     * Set resultMessage value
     * @param string $resultMessage
     * @return \Bitsaf\StructType\BitsafBitsadtoSessionWrapper
     */
    public function setResultMessage($resultMessage = null)
    {
        // validation for constraint: string
        if (!is_null($resultMessage) && !is_string($resultMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultMessage, true), gettype($resultMessage)), __LINE__);
        }
        $this->resultMessage = $resultMessage;
        return $this;
    }
    /**
     * Get sessionId value
     * @return string|null
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param string $sessionId
     * @return \Bitsaf\StructType\BitsafBitsadtoSessionWrapper
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionId, true), gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Bitsaf\StructType\BitsafBitsadtoSessionWrapper
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
