<?php

namespace Bitsaf\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bitsadtoAuthenticationInfoWrapper StructType
 * @package Bitsaf
 * @subpackage Structs
 */
class BitsafBitsadtoAuthenticationInfoWrapper extends AbstractStructBase
{
    /**
     * The generatedToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $generatedToken;
    /**
     * The result
     * @var int
     */
    public $result;
    /**
     * The resultMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $resultMessage;
    /**
     * Constructor method for bitsadtoAuthenticationInfoWrapper
     * @uses BitsafBitsadtoAuthenticationInfoWrapper::setGeneratedToken()
     * @uses BitsafBitsadtoAuthenticationInfoWrapper::setResult()
     * @uses BitsafBitsadtoAuthenticationInfoWrapper::setResultMessage()
     * @param string $generatedToken
     * @param int $result
     * @param string $resultMessage
     */
    public function __construct($generatedToken = null, $result = null, $resultMessage = null)
    {
        $this
            ->setGeneratedToken($generatedToken)
            ->setResult($result)
            ->setResultMessage($resultMessage);
    }
    /**
     * Get generatedToken value
     * @return string|null
     */
    public function getGeneratedToken()
    {
        return $this->generatedToken;
    }
    /**
     * Set generatedToken value
     * @param string $generatedToken
     * @return \Bitsaf\StructType\BitsafBitsadtoAuthenticationInfoWrapper
     */
    public function setGeneratedToken($generatedToken = null)
    {
        // validation for constraint: string
        if (!is_null($generatedToken) && !is_string($generatedToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($generatedToken, true), gettype($generatedToken)), __LINE__);
        }
        $this->generatedToken = $generatedToken;
        return $this;
    }
    /**
     * Get result value
     * @return int|null
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * Set result value
     * @param int $result
     * @return \Bitsaf\StructType\BitsafBitsadtoAuthenticationInfoWrapper
     */
    public function setResult($result = null)
    {
        // validation for constraint: int
        if (!is_null($result) && !(is_int($result) || ctype_digit($result))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        $this->result = $result;
        return $this;
    }
    /**
     * Get resultMessage value
     * @return string|null
     */
    public function getResultMessage()
    {
        return $this->resultMessage;
    }
    /**
     * Set resultMessage value
     * @param string $resultMessage
     * @return \Bitsaf\StructType\BitsafBitsadtoAuthenticationInfoWrapper
     */
    public function setResultMessage($resultMessage = null)
    {
        // validation for constraint: string
        if (!is_null($resultMessage) && !is_string($resultMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultMessage, true), gettype($resultMessage)), __LINE__);
        }
        $this->resultMessage = $resultMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Bitsaf\StructType\BitsafBitsadtoAuthenticationInfoWrapper
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
