<?php

namespace Bitsaf\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Fetch ServiceType
 * @package Bitsaf
 * @subpackage Services
 */
class BitsafFetch extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named fetchAgentDailyToken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $terminalId
     * @param string $userName
     * @param string $password
     * @return \Bitsaf\StructType\BitsafBitsadtoAuthenticationInfoWrapper|bool
     */
    public function fetchAgentDailyToken($terminalId, $userName, $password)
    {
        try {
            $this->setResult($this->getSoapClient()->fetchAgentDailyToken($terminalId, $userName, $password));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Bitsaf\StructType\BitsafBitsadtoAuthenticationInfoWrapper
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
