<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webapi.ihio.gov.ir/bitsaf/cservices/BITSAFImplAuthenticationService?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webapi.ihio.gov.ir/bitsaf/cservices/BITSAFImplAuthenticationService?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Bitsaf\BitsafClassMap::get(),
);
/**
 * Samples for Open ServiceType
 */
$open = new \Bitsaf\ServiceType\BitsafOpen($options);
/**
 * Sample call for openUserSession operation/method
 */
if ($open->openUserSession($appUserInfo, $terminalId, $token, new \Bitsaf\StructType\BitsafBitsadtoiDentifier(), new \Bitsaf\ArrayType\BitsafBitsadtoiDentifierArray()) !== false) {
    print_r($open->getResult());
} else {
    print_r($open->getLastError());
}
/**
 * Sample call for openCitizenSession operation/method
 */
if ($open->openCitizenSession($appUser, $terminalId, $token, $userSessionId, new \Bitsaf\ArrayType\BitsafBitsadtoiDentifierArray()) !== false) {
    print_r($open->getResult());
} else {
    print_r($open->getLastError());
}
/**
 * Samples for Fetch ServiceType
 */
$fetch = new \Bitsaf\ServiceType\BitsafFetch($options);
/**
 * Sample call for fetchAgentDailyToken operation/method
 */
if ($fetch->fetchAgentDailyToken($terminalId, $userName, $password) !== false) {
    print_r($fetch->getResult());
} else {
    print_r($fetch->getLastError());
}
