<?php

namespace Bitsaf\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Open ServiceType
 * @package Bitsaf
 * @subpackage Services
 */
class BitsafOpen extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named openUserSession
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $appUserInfo
     * @param string $terminalId
     * @param string $token
     * @param \Bitsaf\StructType\BitsafBitsadtoiDentifier $hcfInfo
     * @param \Bitsaf\ArrayType\BitsafBitsadtoiDentifierArray $userAuthInfo
     * @return \Bitsaf\StructType\BitsafBitsadtoSessionWrapper|bool
     */
    public function openUserSession($appUserInfo, $terminalId, $token, \Bitsaf\StructType\BitsafBitsadtoiDentifier $hcfInfo, \Bitsaf\ArrayType\BitsafBitsadtoiDentifierArray $userAuthInfo)
    {
        try {
            $this->setResult($this->getSoapClient()->openUserSession($appUserInfo, $terminalId, $token, $hcfInfo, $userAuthInfo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named openCitizenSession
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $appUser
     * @param string $terminalId
     * @param string $token
     * @param string $userSessionId
     * @param \Bitsaf\ArrayType\BitsafBitsadtoiDentifierArray $citizenAuthInfo
     * @return \Bitsaf\StructType\BitsafBitsadtoSessionWrapper|bool
     */
    public function openCitizenSession($appUser, $terminalId, $token, $userSessionId, \Bitsaf\ArrayType\BitsafBitsadtoiDentifierArray $citizenAuthInfo)
    {
        try {
            $this->setResult($this->getSoapClient()->openCitizenSession($appUser, $terminalId, $token, $userSessionId, $citizenAuthInfo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Bitsaf\StructType\BitsafBitsadtoSessionWrapper
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
