<?php

namespace Bitsaf\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for bitsadtoiDentifierArray ArrayType
 * @package Bitsaf
 * @subpackage Arrays
 */
class BitsafBitsadtoiDentifierArray extends AbstractStructArrayBase
{
    /**
     * The identifierInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Bitsaf\StructType\BitsafBitsadtoiDentifier[]
     */
    public $identifierInfo;
    /**
     * Constructor method for bitsadtoiDentifierArray
     * @uses BitsafBitsadtoiDentifierArray::setIdentifierInfo()
     * @param \Bitsaf\StructType\BitsafBitsadtoiDentifier[] $identifierInfo
     */
    public function __construct(array $identifierInfo = array())
    {
        $this
            ->setIdentifierInfo($identifierInfo);
    }
    /**
     * Get identifierInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Bitsaf\StructType\BitsafBitsadtoiDentifier[]|null
     */
    public function getIdentifierInfo()
    {
        return isset($this->identifierInfo) ? $this->identifierInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setIdentifierInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdentifierInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdentifierInfoForArrayConstraintsFromSetIdentifierInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bitsadtoiDentifierArrayIdentifierInfoItem) {
            // validation for constraint: itemType
            if (!$bitsadtoiDentifierArrayIdentifierInfoItem instanceof \Bitsaf\StructType\BitsafBitsadtoiDentifier) {
                $invalidValues[] = is_object($bitsadtoiDentifierArrayIdentifierInfoItem) ? get_class($bitsadtoiDentifierArrayIdentifierInfoItem) : sprintf('%s(%s)', gettype($bitsadtoiDentifierArrayIdentifierInfoItem), var_export($bitsadtoiDentifierArrayIdentifierInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The identifierInfo property can only contain items of type \Bitsaf\StructType\BitsafBitsadtoiDentifier, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set identifierInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Bitsaf\StructType\BitsafBitsadtoiDentifier[] $identifierInfo
     * @return \Bitsaf\ArrayType\BitsafBitsadtoiDentifierArray
     */
    public function setIdentifierInfo(array $identifierInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($identifierInfoArrayErrorMessage = self::validateIdentifierInfoForArrayConstraintsFromSetIdentifierInfo($identifierInfo))) {
            throw new \InvalidArgumentException($identifierInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($identifierInfo) || (is_array($identifierInfo) && empty($identifierInfo))) {
            unset($this->identifierInfo);
        } else {
            $this->identifierInfo = $identifierInfo;
        }
        return $this;
    }
    /**
     * Add item to identifierInfo value
     * @throws \InvalidArgumentException
     * @param \Bitsaf\StructType\BitsafBitsadtoiDentifier $item
     * @return \Bitsaf\ArrayType\BitsafBitsadtoiDentifierArray
     */
    public function addToIdentifierInfo(\Bitsaf\StructType\BitsafBitsadtoiDentifier $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Bitsaf\StructType\BitsafBitsadtoiDentifier) {
            throw new \InvalidArgumentException(sprintf('The identifierInfo property can only contain items of type \Bitsaf\StructType\BitsafBitsadtoiDentifier, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->identifierInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Bitsaf\StructType\BitsafBitsadtoiDentifier|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Bitsaf\StructType\BitsafBitsadtoiDentifier|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Bitsaf\StructType\BitsafBitsadtoiDentifier|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Bitsaf\StructType\BitsafBitsadtoiDentifier|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Bitsaf\StructType\BitsafBitsadtoiDentifier|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string identifierInfo
     */
    public function getAttributeName()
    {
        return 'identifierInfo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Bitsaf\ArrayType\BitsafBitsadtoiDentifierArray
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
