<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpsellType StructType
 * @subpackage Structs
 */
class UpsellType extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Code;
    /**
     * The Name
     * @var \room\StructType\DescriptionType
     */
    public $Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\DescriptionType
     */
    public $Description;
    /**
     * The Price
     * @var float
     */
    public $Price;
    /**
     * The PriceWithoutTax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PriceWithoutTax;
    /**
     * The RegularPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $RegularPrice;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * The ChargeMode
     * @var \room\StructType\ChargeModeType
     */
    public $ChargeMode;
    /**
     * The PostingModes
     * @var \room\StructType\PostingModesType
     */
    public $PostingModes;
    /**
     * The PictureUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PictureUrl;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Quantity;
    /**
     * The ChargePrepayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ChargePrepayment;
    /**
     * The DailyAvailabilities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\DailyAvailabilitiesType
     */
    public $DailyAvailabilities;
    /**
     * Constructor method for UpsellType
     * @uses UpsellType::setCode()
     * @uses UpsellType::setName()
     * @uses UpsellType::setDescription()
     * @uses UpsellType::setPrice()
     * @uses UpsellType::setPriceWithoutTax()
     * @uses UpsellType::setRegularPrice()
     * @uses UpsellType::setCurrency()
     * @uses UpsellType::setChargeMode()
     * @uses UpsellType::setPostingModes()
     * @uses UpsellType::setPictureUrl()
     * @uses UpsellType::setQuantity()
     * @uses UpsellType::setChargePrepayment()
     * @uses UpsellType::setDailyAvailabilities()
     * @param string $code
     * @param \room\StructType\DescriptionType $name
     * @param \room\StructType\DescriptionType $description
     * @param float $price
     * @param float $priceWithoutTax
     * @param float $regularPrice
     * @param string $currency
     * @param \room\StructType\ChargeModeType $chargeMode
     * @param \room\StructType\PostingModesType $postingModes
     * @param string $pictureUrl
     * @param int $quantity
     * @param bool $chargePrepayment
     * @param \room\StructType\DailyAvailabilitiesType $dailyAvailabilities
     */
    public function __construct($code = null, \room\StructType\DescriptionType $name = null, \room\StructType\DescriptionType $description = null, $price = null, $priceWithoutTax = null, $regularPrice = null, $currency = null, \room\StructType\ChargeModeType $chargeMode = null, \room\StructType\PostingModesType $postingModes = null, $pictureUrl = null, $quantity = null, $chargePrepayment = null, \room\StructType\DailyAvailabilitiesType $dailyAvailabilities = null)
    {
        $this
            ->setCode($code)
            ->setName($name)
            ->setDescription($description)
            ->setPrice($price)
            ->setPriceWithoutTax($priceWithoutTax)
            ->setRegularPrice($regularPrice)
            ->setCurrency($currency)
            ->setChargeMode($chargeMode)
            ->setPostingModes($postingModes)
            ->setPictureUrl($pictureUrl)
            ->setQuantity($quantity)
            ->setChargePrepayment($chargePrepayment)
            ->setDailyAvailabilities($dailyAvailabilities);
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \room\StructType\UpsellType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return \room\StructType\DescriptionType|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \room\StructType\DescriptionType $name
     * @return \room\StructType\UpsellType
     */
    public function setName(\room\StructType\DescriptionType $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return \room\StructType\DescriptionType|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \room\StructType\DescriptionType $description
     * @return \room\StructType\UpsellType
     */
    public function setDescription(\room\StructType\DescriptionType $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \room\StructType\UpsellType
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Get PriceWithoutTax value
     * @return float|null
     */
    public function getPriceWithoutTax()
    {
        return $this->PriceWithoutTax;
    }
    /**
     * Set PriceWithoutTax value
     * @param float $priceWithoutTax
     * @return \room\StructType\UpsellType
     */
    public function setPriceWithoutTax($priceWithoutTax = null)
    {
        // validation for constraint: float
        if (!is_null($priceWithoutTax) && !(is_float($priceWithoutTax) || is_numeric($priceWithoutTax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($priceWithoutTax, true), gettype($priceWithoutTax)), __LINE__);
        }
        $this->PriceWithoutTax = $priceWithoutTax;
        return $this;
    }
    /**
     * Get RegularPrice value
     * @return float|null
     */
    public function getRegularPrice()
    {
        return $this->RegularPrice;
    }
    /**
     * Set RegularPrice value
     * @param float $regularPrice
     * @return \room\StructType\UpsellType
     */
    public function setRegularPrice($regularPrice = null)
    {
        // validation for constraint: float
        if (!is_null($regularPrice) && !(is_float($regularPrice) || is_numeric($regularPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($regularPrice, true), gettype($regularPrice)), __LINE__);
        }
        $this->RegularPrice = $regularPrice;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \room\StructType\UpsellType
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get ChargeMode value
     * @return \room\StructType\ChargeModeType|null
     */
    public function getChargeMode()
    {
        return $this->ChargeMode;
    }
    /**
     * Set ChargeMode value
     * @param \room\StructType\ChargeModeType $chargeMode
     * @return \room\StructType\UpsellType
     */
    public function setChargeMode(\room\StructType\ChargeModeType $chargeMode = null)
    {
        $this->ChargeMode = $chargeMode;
        return $this;
    }
    /**
     * Get PostingModes value
     * @return \room\StructType\PostingModesType|null
     */
    public function getPostingModes()
    {
        return $this->PostingModes;
    }
    /**
     * Set PostingModes value
     * @param \room\StructType\PostingModesType $postingModes
     * @return \room\StructType\UpsellType
     */
    public function setPostingModes(\room\StructType\PostingModesType $postingModes = null)
    {
        $this->PostingModes = $postingModes;
        return $this;
    }
    /**
     * Get PictureUrl value
     * @return string|null
     */
    public function getPictureUrl()
    {
        return $this->PictureUrl;
    }
    /**
     * Set PictureUrl value
     * @param string $pictureUrl
     * @return \room\StructType\UpsellType
     */
    public function setPictureUrl($pictureUrl = null)
    {
        // validation for constraint: string
        if (!is_null($pictureUrl) && !is_string($pictureUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pictureUrl, true), gettype($pictureUrl)), __LINE__);
        }
        $this->PictureUrl = $pictureUrl;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \room\StructType\UpsellType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get ChargePrepayment value
     * @return bool|null
     */
    public function getChargePrepayment()
    {
        return $this->ChargePrepayment;
    }
    /**
     * Set ChargePrepayment value
     * @param bool $chargePrepayment
     * @return \room\StructType\UpsellType
     */
    public function setChargePrepayment($chargePrepayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($chargePrepayment) && !is_bool($chargePrepayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($chargePrepayment, true), gettype($chargePrepayment)), __LINE__);
        }
        $this->ChargePrepayment = $chargePrepayment;
        return $this;
    }
    /**
     * Get DailyAvailabilities value
     * @return \room\StructType\DailyAvailabilitiesType|null
     */
    public function getDailyAvailabilities()
    {
        return $this->DailyAvailabilities;
    }
    /**
     * Set DailyAvailabilities value
     * @param \room\StructType\DailyAvailabilitiesType $dailyAvailabilities
     * @return \room\StructType\UpsellType
     */
    public function setDailyAvailabilities(\room\StructType\DailyAvailabilitiesType $dailyAvailabilities = null)
    {
        $this->DailyAvailabilities = $dailyAvailabilities;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\UpsellType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
