<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TotalType StructType
 * @subpackage Structs
 */
class TotalType extends AbstractStructBase
{
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $CurrencyCode;
    /**
     * The TotalAmountAfterTax
     * Meta information extracted from the WSDL
     * - use: required
     * @var float
     */
    public $TotalAmountAfterTax;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * Constructor method for TotalType
     * @uses TotalType::setCurrencyCode()
     * @uses TotalType::setTotalAmountAfterTax()
     * @uses TotalType::setDecimalPlaces()
     * @param string $currencyCode
     * @param float $totalAmountAfterTax
     * @param int $decimalPlaces
     */
    public function __construct($currencyCode = null, $totalAmountAfterTax = null, $decimalPlaces = null)
    {
        $this
            ->setCurrencyCode($currencyCode)
            ->setTotalAmountAfterTax($totalAmountAfterTax)
            ->setDecimalPlaces($decimalPlaces);
    }
    /**
     * Get CurrencyCode value
     * @return string
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \room\StructType\TotalType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get TotalAmountAfterTax value
     * @return float
     */
    public function getTotalAmountAfterTax()
    {
        return $this->TotalAmountAfterTax;
    }
    /**
     * Set TotalAmountAfterTax value
     * @param float $totalAmountAfterTax
     * @return \room\StructType\TotalType
     */
    public function setTotalAmountAfterTax($totalAmountAfterTax = null)
    {
        // validation for constraint: float
        if (!is_null($totalAmountAfterTax) && !(is_float($totalAmountAfterTax) || is_numeric($totalAmountAfterTax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAmountAfterTax, true), gettype($totalAmountAfterTax)), __LINE__);
        }
        $this->TotalAmountAfterTax = $totalAmountAfterTax;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \room\StructType\TotalType
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\TotalType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
