<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketItemType StructType
 * @subpackage Structs
 */
class TicketItemType extends AbstractStructBase
{
    /**
     * The EventCode
     * @var string
     */
    public $EventCode;
    /**
     * The EventRoomName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EventRoomName;
    /**
     * The EventStartDate
     * @var string
     */
    public $EventStartDate;
    /**
     * The EventEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EventEndDate;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The AdultTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AdultTickets;
    /**
     * The ChildrenTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ChildrenTickets;
    /**
     * The TotalPrice
     * @var float
     */
    public $TotalPrice;
    /**
     * The DepositAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DepositAmount;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DCCType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\DCCType
     */
    public $DCCType;
    /**
     * Constructor method for TicketItemType
     * @uses TicketItemType::setEventCode()
     * @uses TicketItemType::setEventRoomName()
     * @uses TicketItemType::setEventStartDate()
     * @uses TicketItemType::setEventEndDate()
     * @uses TicketItemType::setQuantity()
     * @uses TicketItemType::setAdultTickets()
     * @uses TicketItemType::setChildrenTickets()
     * @uses TicketItemType::setTotalPrice()
     * @uses TicketItemType::setDepositAmount()
     * @uses TicketItemType::setCurrencyCode()
     * @uses TicketItemType::setDCCType()
     * @param string $eventCode
     * @param string $eventRoomName
     * @param string $eventStartDate
     * @param string $eventEndDate
     * @param int $quantity
     * @param int $adultTickets
     * @param int $childrenTickets
     * @param float $totalPrice
     * @param float $depositAmount
     * @param string $currencyCode
     * @param \room\StructType\DCCType $dCCType
     */
    public function __construct($eventCode = null, $eventRoomName = null, $eventStartDate = null, $eventEndDate = null, $quantity = null, $adultTickets = null, $childrenTickets = null, $totalPrice = null, $depositAmount = null, $currencyCode = null, \room\StructType\DCCType $dCCType = null)
    {
        $this
            ->setEventCode($eventCode)
            ->setEventRoomName($eventRoomName)
            ->setEventStartDate($eventStartDate)
            ->setEventEndDate($eventEndDate)
            ->setQuantity($quantity)
            ->setAdultTickets($adultTickets)
            ->setChildrenTickets($childrenTickets)
            ->setTotalPrice($totalPrice)
            ->setDepositAmount($depositAmount)
            ->setCurrencyCode($currencyCode)
            ->setDCCType($dCCType);
    }
    /**
     * Get EventCode value
     * @return string|null
     */
    public function getEventCode()
    {
        return $this->EventCode;
    }
    /**
     * Set EventCode value
     * @param string $eventCode
     * @return \room\StructType\TicketItemType
     */
    public function setEventCode($eventCode = null)
    {
        // validation for constraint: string
        if (!is_null($eventCode) && !is_string($eventCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventCode, true), gettype($eventCode)), __LINE__);
        }
        $this->EventCode = $eventCode;
        return $this;
    }
    /**
     * Get EventRoomName value
     * @return string|null
     */
    public function getEventRoomName()
    {
        return $this->EventRoomName;
    }
    /**
     * Set EventRoomName value
     * @param string $eventRoomName
     * @return \room\StructType\TicketItemType
     */
    public function setEventRoomName($eventRoomName = null)
    {
        // validation for constraint: string
        if (!is_null($eventRoomName) && !is_string($eventRoomName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventRoomName, true), gettype($eventRoomName)), __LINE__);
        }
        $this->EventRoomName = $eventRoomName;
        return $this;
    }
    /**
     * Get EventStartDate value
     * @return string|null
     */
    public function getEventStartDate()
    {
        return $this->EventStartDate;
    }
    /**
     * Set EventStartDate value
     * @param string $eventStartDate
     * @return \room\StructType\TicketItemType
     */
    public function setEventStartDate($eventStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventStartDate) && !is_string($eventStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventStartDate, true), gettype($eventStartDate)), __LINE__);
        }
        $this->EventStartDate = $eventStartDate;
        return $this;
    }
    /**
     * Get EventEndDate value
     * @return string|null
     */
    public function getEventEndDate()
    {
        return $this->EventEndDate;
    }
    /**
     * Set EventEndDate value
     * @param string $eventEndDate
     * @return \room\StructType\TicketItemType
     */
    public function setEventEndDate($eventEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventEndDate) && !is_string($eventEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventEndDate, true), gettype($eventEndDate)), __LINE__);
        }
        $this->EventEndDate = $eventEndDate;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \room\StructType\TicketItemType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get AdultTickets value
     * @return int|null
     */
    public function getAdultTickets()
    {
        return $this->AdultTickets;
    }
    /**
     * Set AdultTickets value
     * @param int $adultTickets
     * @return \room\StructType\TicketItemType
     */
    public function setAdultTickets($adultTickets = null)
    {
        // validation for constraint: int
        if (!is_null($adultTickets) && !(is_int($adultTickets) || ctype_digit($adultTickets))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($adultTickets, true), gettype($adultTickets)), __LINE__);
        }
        $this->AdultTickets = $adultTickets;
        return $this;
    }
    /**
     * Get ChildrenTickets value
     * @return int|null
     */
    public function getChildrenTickets()
    {
        return $this->ChildrenTickets;
    }
    /**
     * Set ChildrenTickets value
     * @param int $childrenTickets
     * @return \room\StructType\TicketItemType
     */
    public function setChildrenTickets($childrenTickets = null)
    {
        // validation for constraint: int
        if (!is_null($childrenTickets) && !(is_int($childrenTickets) || ctype_digit($childrenTickets))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($childrenTickets, true), gettype($childrenTickets)), __LINE__);
        }
        $this->ChildrenTickets = $childrenTickets;
        return $this;
    }
    /**
     * Get TotalPrice value
     * @return float|null
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param float $totalPrice
     * @return \room\StructType\TicketItemType
     */
    public function setTotalPrice($totalPrice = null)
    {
        // validation for constraint: float
        if (!is_null($totalPrice) && !(is_float($totalPrice) || is_numeric($totalPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalPrice, true), gettype($totalPrice)), __LINE__);
        }
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get DepositAmount value
     * @return float|null
     */
    public function getDepositAmount()
    {
        return $this->DepositAmount;
    }
    /**
     * Set DepositAmount value
     * @param float $depositAmount
     * @return \room\StructType\TicketItemType
     */
    public function setDepositAmount($depositAmount = null)
    {
        // validation for constraint: float
        if (!is_null($depositAmount) && !(is_float($depositAmount) || is_numeric($depositAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($depositAmount, true), gettype($depositAmount)), __LINE__);
        }
        $this->DepositAmount = $depositAmount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \room\StructType\TicketItemType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DCCType value
     * @return \room\StructType\DCCType|null
     */
    public function getDCCType()
    {
        return $this->DCCType;
    }
    /**
     * Set DCCType value
     * @param \room\StructType\DCCType $dCCType
     * @return \room\StructType\TicketItemType
     */
    public function setDCCType(\room\StructType\DCCType $dCCType = null)
    {
        $this->DCCType = $dCCType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\TicketItemType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
