<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StayDetailsType StructType
 * @subpackage Structs
 */
class StayDetailsType extends AbstractStructBase
{
    /**
     * The GuestCounts
     * @var \room\StructType\GuestCountsType
     */
    public $GuestCounts;
    /**
     * The StayDateRange
     * @var \room\StructType\StayDateRangeType
     */
    public $StayDateRange;
    /**
     * The PromotionalCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PromotionalCode;
    /**
     * Constructor method for StayDetailsType
     * @uses StayDetailsType::setGuestCounts()
     * @uses StayDetailsType::setStayDateRange()
     * @uses StayDetailsType::setPromotionalCode()
     * @param \room\StructType\GuestCountsType $guestCounts
     * @param \room\StructType\StayDateRangeType $stayDateRange
     * @param string $promotionalCode
     */
    public function __construct(\room\StructType\GuestCountsType $guestCounts = null, \room\StructType\StayDateRangeType $stayDateRange = null, $promotionalCode = null)
    {
        $this
            ->setGuestCounts($guestCounts)
            ->setStayDateRange($stayDateRange)
            ->setPromotionalCode($promotionalCode);
    }
    /**
     * Get GuestCounts value
     * @return \room\StructType\GuestCountsType|null
     */
    public function getGuestCounts()
    {
        return $this->GuestCounts;
    }
    /**
     * Set GuestCounts value
     * @param \room\StructType\GuestCountsType $guestCounts
     * @return \room\StructType\StayDetailsType
     */
    public function setGuestCounts(\room\StructType\GuestCountsType $guestCounts = null)
    {
        $this->GuestCounts = $guestCounts;
        return $this;
    }
    /**
     * Get StayDateRange value
     * @return \room\StructType\StayDateRangeType|null
     */
    public function getStayDateRange()
    {
        return $this->StayDateRange;
    }
    /**
     * Set StayDateRange value
     * @param \room\StructType\StayDateRangeType $stayDateRange
     * @return \room\StructType\StayDetailsType
     */
    public function setStayDateRange(\room\StructType\StayDateRangeType $stayDateRange = null)
    {
        $this->StayDateRange = $stayDateRange;
        return $this;
    }
    /**
     * Get PromotionalCode value
     * @return string|null
     */
    public function getPromotionalCode()
    {
        return $this->PromotionalCode;
    }
    /**
     * Set PromotionalCode value
     * @param string $promotionalCode
     * @return \room\StructType\StayDetailsType
     */
    public function setPromotionalCode($promotionalCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionalCode) && !is_string($promotionalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionalCode, true), gettype($promotionalCode)), __LINE__);
        }
        $this->PromotionalCode = $promotionalCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\StayDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
