<?php

namespace room\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomStayType StructType
 * @subpackage Structs
 */
class RoomStayType extends AbstractStructBase
{
    /**
     * The IndexNumber
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $IndexNumber;
    /**
     * The RoomRates
     * @var \room\StructType\RoomRatesType
     */
    public $RoomRates;
    /**
     * The Upsells
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\UpsellsType
     */
    public $Upsells;
    /**
     * The GuestCounts
     * @var \room\StructType\GuestCountsType
     */
    public $GuestCounts;
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\TotalType
     */
    public $Total;
    /**
     * The TotalCostOfStay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\TotalType
     */
    public $TotalCostOfStay;
    /**
     * The ResGuestRPHs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\ResGuestRPHsType
     */
    public $ResGuestRPHs;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The Deposit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\DepositType
     */
    public $Deposit;
    /**
     * The RoomNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RoomNumber;
    /**
     * The Company
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\CompanyType
     */
    public $Company;
    /**
     * The AllocateRoomNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AllocateRoomNumber;
    /**
     * The ResDiaryReferences
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \room\StructType\ResDiaryReferencesType
     */
    public $ResDiaryReferences;
    /**
     * Constructor method for RoomStayType
     * @uses RoomStayType::setIndexNumber()
     * @uses RoomStayType::setRoomRates()
     * @uses RoomStayType::setUpsells()
     * @uses RoomStayType::setGuestCounts()
     * @uses RoomStayType::setTotal()
     * @uses RoomStayType::setTotalCostOfStay()
     * @uses RoomStayType::setResGuestRPHs()
     * @uses RoomStayType::setNotes()
     * @uses RoomStayType::setDeposit()
     * @uses RoomStayType::setRoomNumber()
     * @uses RoomStayType::setCompany()
     * @uses RoomStayType::setAllocateRoomNumber()
     * @uses RoomStayType::setResDiaryReferences()
     * @param int $indexNumber
     * @param \room\StructType\RoomRatesType $roomRates
     * @param \room\StructType\UpsellsType $upsells
     * @param \room\StructType\GuestCountsType $guestCounts
     * @param \room\StructType\TotalType $total
     * @param \room\StructType\TotalType $totalCostOfStay
     * @param \room\StructType\ResGuestRPHsType $resGuestRPHs
     * @param string $notes
     * @param \room\StructType\DepositType $deposit
     * @param string $roomNumber
     * @param \room\StructType\CompanyType $company
     * @param string $allocateRoomNumber
     * @param \room\StructType\ResDiaryReferencesType $resDiaryReferences
     */
    public function __construct($indexNumber = null, \room\StructType\RoomRatesType $roomRates = null, \room\StructType\UpsellsType $upsells = null, \room\StructType\GuestCountsType $guestCounts = null, \room\StructType\TotalType $total = null, \room\StructType\TotalType $totalCostOfStay = null, \room\StructType\ResGuestRPHsType $resGuestRPHs = null, $notes = null, \room\StructType\DepositType $deposit = null, $roomNumber = null, \room\StructType\CompanyType $company = null, $allocateRoomNumber = null, \room\StructType\ResDiaryReferencesType $resDiaryReferences = null)
    {
        $this
            ->setIndexNumber($indexNumber)
            ->setRoomRates($roomRates)
            ->setUpsells($upsells)
            ->setGuestCounts($guestCounts)
            ->setTotal($total)
            ->setTotalCostOfStay($totalCostOfStay)
            ->setResGuestRPHs($resGuestRPHs)
            ->setNotes($notes)
            ->setDeposit($deposit)
            ->setRoomNumber($roomNumber)
            ->setCompany($company)
            ->setAllocateRoomNumber($allocateRoomNumber)
            ->setResDiaryReferences($resDiaryReferences);
    }
    /**
     * Get IndexNumber value
     * @return int
     */
    public function getIndexNumber()
    {
        return $this->IndexNumber;
    }
    /**
     * Set IndexNumber value
     * @param int $indexNumber
     * @return \room\StructType\RoomStayType
     */
    public function setIndexNumber($indexNumber = null)
    {
        // validation for constraint: int
        if (!is_null($indexNumber) && !(is_int($indexNumber) || ctype_digit($indexNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($indexNumber, true), gettype($indexNumber)), __LINE__);
        }
        $this->IndexNumber = $indexNumber;
        return $this;
    }
    /**
     * Get RoomRates value
     * @return \room\StructType\RoomRatesType|null
     */
    public function getRoomRates()
    {
        return $this->RoomRates;
    }
    /**
     * Set RoomRates value
     * @param \room\StructType\RoomRatesType $roomRates
     * @return \room\StructType\RoomStayType
     */
    public function setRoomRates(\room\StructType\RoomRatesType $roomRates = null)
    {
        $this->RoomRates = $roomRates;
        return $this;
    }
    /**
     * Get Upsells value
     * @return \room\StructType\UpsellsType|null
     */
    public function getUpsells()
    {
        return $this->Upsells;
    }
    /**
     * Set Upsells value
     * @param \room\StructType\UpsellsType $upsells
     * @return \room\StructType\RoomStayType
     */
    public function setUpsells(\room\StructType\UpsellsType $upsells = null)
    {
        $this->Upsells = $upsells;
        return $this;
    }
    /**
     * Get GuestCounts value
     * @return \room\StructType\GuestCountsType|null
     */
    public function getGuestCounts()
    {
        return $this->GuestCounts;
    }
    /**
     * Set GuestCounts value
     * @param \room\StructType\GuestCountsType $guestCounts
     * @return \room\StructType\RoomStayType
     */
    public function setGuestCounts(\room\StructType\GuestCountsType $guestCounts = null)
    {
        $this->GuestCounts = $guestCounts;
        return $this;
    }
    /**
     * Get Total value
     * @return \room\StructType\TotalType|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param \room\StructType\TotalType $total
     * @return \room\StructType\RoomStayType
     */
    public function setTotal(\room\StructType\TotalType $total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Get TotalCostOfStay value
     * @return \room\StructType\TotalType|null
     */
    public function getTotalCostOfStay()
    {
        return $this->TotalCostOfStay;
    }
    /**
     * Set TotalCostOfStay value
     * @param \room\StructType\TotalType $totalCostOfStay
     * @return \room\StructType\RoomStayType
     */
    public function setTotalCostOfStay(\room\StructType\TotalType $totalCostOfStay = null)
    {
        $this->TotalCostOfStay = $totalCostOfStay;
        return $this;
    }
    /**
     * Get ResGuestRPHs value
     * @return \room\StructType\ResGuestRPHsType|null
     */
    public function getResGuestRPHs()
    {
        return $this->ResGuestRPHs;
    }
    /**
     * Set ResGuestRPHs value
     * @param \room\StructType\ResGuestRPHsType $resGuestRPHs
     * @return \room\StructType\RoomStayType
     */
    public function setResGuestRPHs(\room\StructType\ResGuestRPHsType $resGuestRPHs = null)
    {
        $this->ResGuestRPHs = $resGuestRPHs;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \room\StructType\RoomStayType
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get Deposit value
     * @return \room\StructType\DepositType|null
     */
    public function getDeposit()
    {
        return $this->Deposit;
    }
    /**
     * Set Deposit value
     * @param \room\StructType\DepositType $deposit
     * @return \room\StructType\RoomStayType
     */
    public function setDeposit(\room\StructType\DepositType $deposit = null)
    {
        $this->Deposit = $deposit;
        return $this;
    }
    /**
     * Get RoomNumber value
     * @return string|null
     */
    public function getRoomNumber()
    {
        return $this->RoomNumber;
    }
    /**
     * Set RoomNumber value
     * @param string $roomNumber
     * @return \room\StructType\RoomStayType
     */
    public function setRoomNumber($roomNumber = null)
    {
        // validation for constraint: string
        if (!is_null($roomNumber) && !is_string($roomNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomNumber, true), gettype($roomNumber)), __LINE__);
        }
        $this->RoomNumber = $roomNumber;
        return $this;
    }
    /**
     * Get Company value
     * @return \room\StructType\CompanyType|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * Set Company value
     * @param \room\StructType\CompanyType $company
     * @return \room\StructType\RoomStayType
     */
    public function setCompany(\room\StructType\CompanyType $company = null)
    {
        $this->Company = $company;
        return $this;
    }
    /**
     * Get AllocateRoomNumber value
     * @return string|null
     */
    public function getAllocateRoomNumber()
    {
        return $this->AllocateRoomNumber;
    }
    /**
     * Set AllocateRoomNumber value
     * @param string $allocateRoomNumber
     * @return \room\StructType\RoomStayType
     */
    public function setAllocateRoomNumber($allocateRoomNumber = null)
    {
        // validation for constraint: string
        if (!is_null($allocateRoomNumber) && !is_string($allocateRoomNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allocateRoomNumber, true), gettype($allocateRoomNumber)), __LINE__);
        }
        $this->AllocateRoomNumber = $allocateRoomNumber;
        return $this;
    }
    /**
     * Get ResDiaryReferences value
     * @return \room\StructType\ResDiaryReferencesType|null
     */
    public function getResDiaryReferences()
    {
        return $this->ResDiaryReferences;
    }
    /**
     * Set ResDiaryReferences value
     * @param \room\StructType\ResDiaryReferencesType $resDiaryReferences
     * @return \room\StructType\RoomStayType
     */
    public function setResDiaryReferences(\room\StructType\ResDiaryReferencesType $resDiaryReferences = null)
    {
        $this->ResDiaryReferences = $resDiaryReferences;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \room\StructType\RoomStayType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
